/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl;

import com.ur.disk.Directories;
import com.ur.lang.StringUtils;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.swing.HourFormat;
import com.ur.swing.KeyboardLayouts;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.text.KeyboardLayoutHolder;
import com.ur.swing.units.UnitType;
import com.ur.swing.units.Units;
import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;

public class Settings {
    private static final String LANGUAGE = "language";
    private static final String ENGLISH_PROGRAMMING = "englishProgramming";
    private static final String REGION = "region";
    private static final String UNITS_KEY = "units";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String HOUR_FORMAT = "hourFormat";
    private static final String SETTINGS_FILENAME = "gui.properties";
    private static final String USER = System.getenv("USER") == null ? "dummy" : System.getenv("USER");
    private static final String CONFIGURATION_AND_SETTINGS_PATH = Settings.loadConfigurationAndSettingsPath();
    private static final String LOAD_IMAGES_PATH = "loadImagesPath";
    private static final int DEFAULT_DATE_FORMAT = 1;
    private static final String KEYBOARD_LAYOUT = "KeyboardLayout";
    private static NiceProperties properties;
    private static HourFormat hourFormatChoice;
    private static int dateFormatStyleChoice;
    private static UnitType units;
    private static LanguageConfiguration languageSettings;

    private static NiceProperties getProperties() {
        if (properties == null) {
            properties = new NiceProperties(Settings.readPropertiesFile(SETTINGS_FILENAME));
            System.setProperty("urcontrol.home", Directories.urcontrol().getPath());
            Settings.loadLanguage();
            if (properties.containsKey(REGION)) {
                String regionStr = properties.getProperty(REGION, LanguageConfiguration.Region.GLOBAL.getName()).replace("_", "");
                languageSettings.setRegion(LanguageConfiguration.Region.getRegion((String)regionStr));
            }
            if (properties.containsKey(HOUR_FORMAT)) {
                String hourFormatStr = properties.getProperty(HOUR_FORMAT, "");
                Settings.setHourFormat(HourFormat.getHourFormat((String)hourFormatStr));
            } else {
                Settings.setHourFormat(languageSettings.getRegion().getDefaultHourFormat());
            }
            dateFormatStyleChoice = properties.getInteger(DATE_FORMAT, 1);
            Settings.setUnits(UnitType.getUnitType((String)properties.getProperty(UNITS_KEY, "")));
            Settings.updateKeyboardLayoutHolder(properties.getProperty(KEYBOARD_LAYOUT, "en"));
            System.setProperty(LOAD_IMAGES_PATH, properties.getProperty(LOAD_IMAGES_PATH, Directories.home() + "/Pictures/"));
        }
        return properties;
    }

    public static HourFormat getHourFormatChoice() {
        return hourFormatChoice;
    }

    public static SimpleDateFormat getTimeDisplayFormat() {
        Settings.getProperties();
        return new SimpleDateFormat(hourFormatChoice.getDisplayString());
    }

    public static void setDateFormatStyleChoice(int dateStyle) {
        dateFormatStyleChoice = dateStyle == 3 || dateStyle == 2 ? dateStyle : 1;
        Settings.getProperties().setProperty(DATE_FORMAT, "" + dateStyle);
    }

    public static int getDateFormatStyleChoice() {
        Settings.getProperties();
        return dateFormatStyleChoice;
    }

    public static DateFormat getDateFormat() {
        Settings.getProperties();
        return DateFormat.getDateInstance(dateFormatStyleChoice, Settings.getLanguageSettings().getLanguage().getLocale());
    }

    public static LanguageConfiguration.SupportedLanguage getLanguage() {
        Settings.getProperties();
        return Settings.getLanguageSettings().getLanguage();
    }

    public static LanguageConfiguration.Region getRegion() {
        Settings.getProperties();
        return Settings.getLanguageSettings().getRegion();
    }

    public static boolean getIsUsingEnglishProgramming() {
        Settings.getProperties();
        return Settings.getLanguageSettings().isUsingEnglishProgramming();
    }

    public static void setUseEnglishProgramming(boolean useEnglishProgrammingState) {
        Settings.getLanguageSettings().setUseEnglishProgramming(useEnglishProgrammingState);
        Settings.getProperties().setProperty(ENGLISH_PROGRAMMING, useEnglishProgrammingState + "");
    }

    private static void updateKeyboardLayoutHolder(String keyboardLayout) {
        KeyboardLayoutHolder.setKeyboardLayout((KeyboardLayouts)KeyboardLayouts.valueOf((String)keyboardLayout));
    }

    public static void setKeyboardLayout(String keyboardLayout) {
        Settings.getProperties().setProperty(KEYBOARD_LAYOUT, keyboardLayout);
        Settings.updateKeyboardLayoutHolder(Settings.getKeyboardLayout());
        Settings.saveSettings();
    }

    public static KeyboardLayouts getKeyboardLayouts() {
        return KeyboardLayouts.valueOf((String)Settings.getKeyboardLayout());
    }

    public static String getKeyboardLayout() {
        return Settings.getProperties().getProperty(KEYBOARD_LAYOUT, "en");
    }

    private static LanguageConfiguration getLanguageSettings() {
        if (languageSettings == null) {
            Settings.getProperties();
        }
        return languageSettings;
    }

    public static void setHourFormat(HourFormat hourFormat) {
        hourFormatChoice = hourFormat;
        Settings.getProperties().setProperty(HOUR_FORMAT, hourFormat.name().toLowerCase());
    }

    public static void setUnits(UnitType units) {
        Settings.getProperties().setProperty(UNITS_KEY, units.name());
        Settings.units = units;
        com.ur.polyscope.valueobjects.converters.UnitType unitType = units.isUS() ? com.ur.polyscope.valueobjects.converters.UnitType.US : com.ur.polyscope.valueobjects.converters.UnitType.METRIC;
        com.ur.polyscope.valueobjects.converters.Units.setUnitType((com.ur.polyscope.valueobjects.converters.UnitType)unitType);
        Units.setUnitType((UnitType)units);
    }

    public static void setRegion(LanguageConfiguration.Region region) {
        Settings.getLanguageSettings().setRegion(region);
        Settings.getProperties().setProperty(REGION, region.getName());
    }

    public static void setLanguage(LanguageConfiguration.SupportedLanguage language) {
        Settings.getProperties().setProperty(LANGUAGE, language.getLanguageName());
        Settings.getLanguageSettings().setLanguage(language);
    }

    public static UnitType getUnits() {
        if (units == null) {
            Settings.getProperties();
        }
        return units;
    }

    private static String loadConfigurationAndSettingsPath() {
        Log.info((String)("Robot controller user = " + USER));
        String configSettingsPath = Directories.urcontrol().getPath();
        Log.info((String)("Configuration and settings files path: " + configSettingsPath));
        return configSettingsPath;
    }

    private static void loadLanguage() {
        try {
            String language = Settings.getProperties().getProperty(LANGUAGE, null);
            LanguageConfiguration.SupportedLanguage supportedLanguage = LanguageConfiguration.SupportedLanguage.getLanguage((String)language);
            boolean isImplicitEnglishProgramming = supportedLanguage == LanguageConfiguration.SupportedLanguage.en || supportedLanguage == LanguageConfiguration.SupportedLanguage.us;
            boolean englishProgramming = Settings.getProperties().getBoolean(ENGLISH_PROGRAMMING, isImplicitEnglishProgramming);
            if (language == null && new File(CONFIGURATION_AND_SETTINGS_PATH + File.separator + LANGUAGE).exists()) {
                language = FileUtils.readFromFile((File)new File(CONFIGURATION_AND_SETTINGS_PATH + File.separator + LANGUAGE), null);
                englishProgramming = language.contains("pe");
            }
            if (StringUtils.isNullOrOnlyWhitespace((String)language)) {
                language = "";
            }
            languageSettings = new LanguageConfiguration(LanguageConfiguration.SupportedLanguage.getLanguage((String)language), LanguageConfiguration.Region.GLOBAL, englishProgramming);
        }
        catch (Exception e) {
            languageSettings = new LanguageConfiguration();
            Log.warning((String)"Failed to load language file: Possibly corrupted or empty");
        }
    }

    private static Properties readPropertiesFile(String fileName) {
        String fileNameAndPath = CONFIGURATION_AND_SETTINGS_PATH + File.separator + fileName;
        try {
            return FileUtils.readPropertiesFromFile((String)fileNameAndPath);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException ex) {
            Log.error((String)("Error while reading configuration file, '" + fileNameAndPath + "': "), (Throwable)ex);
        }
        return new Properties();
    }

    public static void saveSettings() {
        try {
            if (properties.hasChanges()) {
                FileUtils.writePropertiesToFile((String)(CONFIGURATION_AND_SETTINGS_PATH + File.separator + SETTINGS_FILENAME), (NiceProperties)properties);
                if (Settings.getProperties().containsKey(LANGUAGE)) {
                    new File(CONFIGURATION_AND_SETTINGS_PATH + File.separator + LANGUAGE).delete();
                }
            }
        }
        catch (IOException ex) {
            Log.warning((String)("Error while saving configuration file, '" + CONFIGURATION_AND_SETTINGS_PATH + File.separator + SETTINGS_FILENAME + "': "));
        }
    }

    public static void setupIsUsingEnglishProgramming() {
        if (Settings.getIsUsingEnglishProgramming()) {
            FeatureToggle.activateFeature((String)ENGLISH_PROGRAMMING);
        } else {
            FeatureToggle.deactivateFeature((String)ENGLISH_PROGRAMMING);
        }
    }
}

