/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.backuprestore;

import com.ur.polyscope.system.impl.ImageResource;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.backuprestore.BackupRestorePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class BackupRestoreLayoutStrategy {
    private static final int AREA_WIDTH = 1000;
    private static final int ROW_HEIGHT = 24;
    private static final int LINE_HEIGHT = 40;
    private static final Font buttonFont = new Font("Arial", 0, 16);
    private static final Font buttonFontBold = new Font("Arial", 1, 16);
    private static final Dimension buttonDimensions = new Dimension(170, 30);

    private BackupRestoreLayoutStrategy() {
    }

    public static void applyLayoutTo(BackupRestorePanel panel, TextResource text) {
        panel.btnBackupSelectLocation.setFont(buttonFont);
        BackupRestoreLayoutStrategy.setDimension(panel.btnBackupSelectLocation, buttonDimensions);
        panel.btnBackupStartBackup.setFont(buttonFontBold);
        BackupRestoreLayoutStrategy.setDimension(panel.btnBackupStartBackup, buttonDimensions);
        panel.btnRestoreSelectLocation.setFont(buttonFont);
        BackupRestoreLayoutStrategy.setDimension(panel.btnRestoreSelectLocation, buttonDimensions);
        panel.btnRestoreStartRestore.setFont(buttonFontBold);
        BackupRestoreLayoutStrategy.setDimension(panel.btnRestoreStartRestore, buttonDimensions);
        panel.setLayout(new BoxLayout((Container)((Object)panel), 3));
        panel.setAlignmentX(0.0f);
        panel.backupPanel = BackupRestoreLayoutStrategy.createBoxLayoutPanel(new Dimension(1000, 215), 3);
        panel.backupPanel.add(BackupRestoreLayoutStrategy.createBorderText(text.backupEntireSystem()));
        panel.backupPanel.add(BackupRestoreLayoutStrategy.createBorderText(text.backupRequireExternalUSB(), ImageResource.formWarning()));
        JPanel backupStep1And2Line = BackupRestoreLayoutStrategy.createBoxWithElements(new Dimension(1000, 50), 2, 10, Box.createRigidArea(new Dimension(0, 10)), BackupRestoreLayoutStrategy.createBorderText(text.backupStep1SelectLocation()), Box.createRigidArea(new Dimension(100, 10)), BackupRestoreLayoutStrategy.createBorderText(text.backupStep2StartBackup()));
        panel.backupPanel.add(backupStep1And2Line);
        JPanel changeLocationStartBackupLine = BackupRestoreLayoutStrategy.createBoxWithElements(new Dimension(1000, 40), 2, 10, Box.createRigidArea(new Dimension(75, 10)), panel.btnBackupSelectLocation, Box.createRigidArea(new Dimension(350, 10)), panel.btnBackupStartBackup);
        panel.backupPanel.add(changeLocationStartBackupLine);
        JPanel backupPathLine = BackupRestoreLayoutStrategy.createBoxWithElements(new Dimension(1000, 40), 2, 10, Box.createRigidArea(new Dimension(75, 10)), panel.backupPath);
        panel.backupPanel.add(backupPathLine);
        panel.restorePanel = BackupRestoreLayoutStrategy.createBoxLayoutPanel(new Dimension(1000, 214), 3);
        panel.restorePanel.add(BackupRestoreLayoutStrategy.createBorderText(text.restoreIfYouHave()));
        panel.restorePanel.add(BackupRestoreLayoutStrategy.createBorderText(text.restoreBeAware(), ImageResource.formWarning()));
        JPanel restoreStep1And2Line = BackupRestoreLayoutStrategy.createBoxWithElements(new Dimension(1000, 40), 2, 10, Box.createRigidArea(new Dimension(0, 10)), BackupRestoreLayoutStrategy.createBorderText(text.restoreStep1Location()), Box.createRigidArea(new Dimension(100, 10)), BackupRestoreLayoutStrategy.createBorderText(text.restoreStep2Restore()));
        panel.restorePanel.add(restoreStep1And2Line);
        JPanel restoreSelectLocationLine = BackupRestoreLayoutStrategy.createBoxWithElements(new Dimension(1000, 40), 2, 10, Box.createRigidArea(new Dimension(75, 10)), panel.btnRestoreSelectLocation, Box.createRigidArea(new Dimension(350, 10)), panel.btnRestoreStartRestore);
        panel.restorePanel.add(restoreSelectLocationLine);
        JPanel restorePathLine = BackupRestoreLayoutStrategy.createBoxWithElements(new Dimension(1000, 40), 2, 10, Box.createRigidArea(new Dimension(75, 10)), panel.restorePath);
        panel.restorePanel.add(restorePathLine);
    }

    private static JLabel createBorderText(String text) {
        return BackupRestoreLayoutStrategy.createBorderText(text, null);
    }

    private static JLabel createBorderText(String text, Icon icon) {
        JLabel label = new JLabel(text);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setBorder(new EmptyBorder(10, 10, 10, 10));
        return label;
    }

    private static JPanel createBoxLayoutPanel(Dimension dimension, int axis) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        BackupRestoreLayoutStrategy.setDimension(panel, dimension);
        return panel;
    }

    private static JPanel createBoxWithElements(Dimension dimension, int axis, int spaceBetweenElements, Component ... component) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        BackupRestoreLayoutStrategy.setDimension(panel, dimension);
        for (int i = 0; i < component.length; ++i) {
            panel.add(component[i]);
            if (i >= component.length - 1) continue;
            if (axis == 2) {
                panel.add(Box.createRigidArea(new Dimension(spaceBetweenElements, 24)));
                continue;
            }
            panel.add(Box.createRigidArea(new Dimension(24, spaceBetweenElements)));
        }
        return panel;
    }

    private static void setDimension(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }
}

