/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.backuprestore;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.system.impl.AbstractSystemPanel;
import com.ur.polyscope.system.impl.backuprestore.BackupRestoreLayoutStrategy;
import com.ur.polyscope.system.impl.backuprestore.RestoreBackupExecuter;
import com.ur.polyscope.system.impl.backuprestore.filemanager.BackupButtonAction;
import com.ur.polyscope.system.impl.backuprestore.filemanager.RestoreButtonAction;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class BackupRestorePanel
extends AbstractSystemPanel
implements AdminLockListener {
    private final BackupButtonAction backupButtonAction;
    private final RestoreButtonAction restoreButtonAction;
    private final transient ConfirmationDialogCreator confirmationDialogCreator;
    private final transient ErrorDialogCreator errorDialogCreator;
    private final AdminLock adminLock;
    public JButton btnBackupSelectLocation;
    public JButton btnBackupStartBackup;
    public JButton btnRestoreSelectLocation;
    public JButton btnRestoreStartRestore;
    public JLabel backupPath;
    public JLabel restorePath;
    JPanel backupPanel;
    JPanel restorePanel;
    private boolean backupStartBtnEnable = false;
    private boolean restoreStartBtnEnable = false;

    @Inject
    public BackupRestorePanel(ViewContext viewContext, RequireAdminPasswordFooter passwordFooter, AdminLock adminLock, BackupButtonAction backupButtonAction, RestoreButtonAction restoreButtonAction) {
        super(passwordFooter, viewContext);
        this.adminLock = adminLock;
        this.confirmationDialogCreator = viewContext.getDialogCreator();
        this.errorDialogCreator = viewContext.getDialogCreator();
        this.backupButtonAction = backupButtonAction;
        this.restoreButtonAction = restoreButtonAction;
        this.initComponents();
        this.setupActions();
        if (FeatureToggle.isActive((String)"systemPassword")) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    private void initComponents() {
        this.backupPanel = new JPanel();
        this.restorePanel = new JPanel();
        this.btnBackupSelectLocation = new JButton(this.backupButtonAction);
        this.btnBackupSelectLocation.setText(this.textResource.selectLocation());
        this.btnBackupStartBackup = new JButton(this.textResource.startBackup());
        this.disableButton(this.btnBackupStartBackup);
        this.btnRestoreSelectLocation = new JButton(this.restoreButtonAction);
        this.btnRestoreSelectLocation.setText(this.textResource.selectFile());
        this.btnRestoreStartRestore = new JButton(this.textResource.restore());
        this.disableButton(this.btnRestoreStartRestore);
        this.backupPath = new JLabel(this.textResource.empty());
        this.restorePath = new JLabel(this.textResource.empty());
        BackupRestoreLayoutStrategy.applyLayoutTo(this, this.textResource);
        JPanel contentPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        contentPanel.setBackground(UIManager.getColor("CardPanel.background"));
        contentPanel.add(this.createCard(this.textResource.systemBackupHeadline(), this.backupPanel));
        contentPanel.add(this.createCard(this.textResource.restoreSystemHeadline(), this.restorePanel));
        this.setLayout(new BorderLayout());
        this.add(contentPanel, "Center");
        this.addPasswordFooter();
        if (this.isAdminPasswordProtected() && this.adminLock.isLocked()) {
            this.doLock();
        } else {
            this.doUnlock();
        }
    }

    public void doUnlock() {
        this.enableSecondaryButton(this.btnBackupSelectLocation);
        this.enableSecondaryButton(this.btnRestoreSelectLocation);
        if (this.backupStartBtnEnable) {
            this.enablePrimaryButton(this.btnBackupStartBackup);
        }
        if (this.restoreStartBtnEnable) {
            this.enablePrimaryButton(this.btnRestoreStartRestore);
        }
    }

    public void doLock() {
        this.disableButton(this.btnBackupSelectLocation);
        this.disableButton(this.btnRestoreSelectLocation);
        this.disableButton(this.btnBackupStartBackup);
        this.disableButton(this.btnRestoreStartRestore);
    }

    private void syncSelectedBackupLocationButton() {
        boolean bl = this.backupStartBtnEnable = this.backupButtonAction.getSelectedDirectory() != null && this.backupButtonAction.getSelectedDirectory().isDirectory();
        if (this.backupStartBtnEnable) {
            this.enablePrimaryButton(this.btnBackupStartBackup);
        } else {
            this.disableButton(this.btnBackupStartBackup);
        }
    }

    private void syncSelectedRestoreLocationButton() {
        boolean bl = this.restoreStartBtnEnable = this.restoreButtonAction.getSelectedBackupFile() != null && this.restoreButtonAction.getSelectedBackupFile().isFile();
        if (this.restoreStartBtnEnable) {
            this.enablePrimaryButton(this.btnRestoreStartRestore);
        } else {
            this.disableButton(this.btnRestoreStartRestore);
        }
    }

    private void setupActions() {
        this.backupButtonAction.addPropertyChangeListener(propertyChangeEvent -> {
            String path = propertyChangeEvent.getNewValue().toString();
            this.backupPath.setText(path);
            this.syncSelectedBackupLocationButton();
        });
        this.restoreButtonAction.addPropertyChangeListener(propertyChangeEvent -> {
            String path = propertyChangeEvent.getNewValue().toString();
            if (path.isEmpty()) {
                this.restorePath.setText(this.textResource.empty());
            } else {
                this.restorePath.setText(path);
            }
            this.syncSelectedRestoreLocationButton();
        });
        this.btnBackupStartBackup.addActionListener(actionEvent -> {
            ConfirmationDialogListener confirmationDialogListener = new ConfirmationDialogListener(){

                public void onOkClicked() {
                    if (BackupRestorePanel.this.backupButtonAction.getSelectedDirectory() != null && BackupRestorePanel.this.backupButtonAction.getSelectedDirectory().isDirectory()) {
                        RestoreBackupExecuter.doBackup(BackupRestorePanel.this.backupButtonAction.getSelectedDirectory());
                        BackupRestorePanel.this.disableButton(BackupRestorePanel.this.btnBackupStartBackup);
                    } else {
                        BackupRestorePanel.this.errorDialogCreator.showErrorDialog(new ErrorMessage(BackupRestorePanel.this.textResource.error(), BackupRestorePanel.this.textResource.chooseDirectory(), BackupRestorePanel.this.textResource.chooseDirectoryBeforeStartingBackup()), null);
                    }
                }
            };
            this.confirmationDialogCreator.showConfirmationDialog(new ConfirmationMessage(this.textResource.confirm(), this.textResource.backupRequiresAShutdown(), this.textResource.OK(), this.textResource.CANCEL()), confirmationDialogListener);
        });
        this.btnRestoreStartRestore.addActionListener(actionEvent -> {
            ConfirmationDialogListener confirmationDialogListener = new ConfirmationDialogListener(){

                public void onOkClicked() {
                    if (BackupRestorePanel.this.restoreButtonAction.getSelectedBackupFile() != null && BackupRestorePanel.this.restoreButtonAction.getSelectedBackupFile().isFile()) {
                        RestoreBackupExecuter.doRestore(BackupRestorePanel.this.restoreButtonAction.getSelectedBackupFile());
                    } else {
                        BackupRestorePanel.this.errorDialogCreator.showErrorDialog(new ErrorMessage(BackupRestorePanel.this.textResource.error(), BackupRestorePanel.this.textResource.chooseAValidBackupFile(), BackupRestorePanel.this.textResource.chooseAValidBackupFileText()), null);
                    }
                }
            };
            this.confirmationDialogCreator.showConfirmationDialog(new ConfirmationMessage(this.textResource.confirm(), this.textResource.confirmStartRestoreWarning(), this.textResource.OK(), this.textResource.CANCEL()), confirmationDialogListener);
        });
    }

    private void enableSecondaryButton(JButton button) {
        button.setForeground(Color.BLACK);
        button.setEnabled(true);
    }

    private void enablePrimaryButton(JButton button) {
        button.setForeground(Color.BLACK);
        button.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
        button.setEnabled(true);
    }

    private void disableButton(JButton button) {
        button.setForeground(Color.BLACK);
        button.setBackground(Color.WHITE);
        button.setEnabled(false);
    }
}

