/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.backuprestore;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.ur.polyscope.system.impl.backuprestore.BackupRestoreSettings;
import com.ur.polyscope.system.impl.backuprestore.BackupState;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RestoreBackupExecuter {
    private static final String UPDATE_SCRIPT = "urupdate";

    public static void doBackup(File directory) {
        try {
            BackupRestoreSettings.setBackupPerformedState(BackupState.GOOD);
            Process p = new ProcessBuilder(UPDATE_SCRIPT, "--backup", directory.getAbsolutePath()).start();
            p.waitFor();
            InputStream inputStream = p.getInputStream();
            String s = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
            Log.info((String)("********** " + s));
        }
        catch (IOException ex) {
            Log.error((String)"Failed to write settings to file: ", (Throwable)ex);
        }
        catch (InterruptedException e) {
            Log.error((String)"Interrupted in waiting for backup process to finish", (Throwable)e);
        }
    }

    public static void doRestore(File file) {
        try {
            Process p = new ProcessBuilder(UPDATE_SCRIPT, "--restore", file.getAbsolutePath()).start();
            p.waitFor();
            InputStream inputStream = p.getInputStream();
            String s = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
            Log.info((String)("********** " + s));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

