/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.backuprestore.filemanager;

import com.ur.disk.Directories;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.backuprestore.filemanager.DialogHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.inject.Inject;
import javax.swing.AbstractAction;

public class BackupButtonAction
extends AbstractAction {
    private final transient FilePersistence filePersistence;
    private final transient FileManagerConfiguration fileSelector;
    private File selectedDirectory;
    private transient DialogHandler dialogHandler;

    @Inject
    BackupButtonAction(FilePersistence filePersistence, TextResource textResource, DialogHandler dialogHandler) {
        this.filePersistence = filePersistence;
        this.dialogHandler = dialogHandler;
        this.fileSelector = new FileManagerConfiguration(textResource.selectLocation(), FileManagerConfiguration.Access.UNRESTRICTED, Directories.programs(), true, new URFileFilter[]{new RegistrationFileFilter(textResource)});
        this.initActionProperties();
    }

    private void initActionProperties() {
        this.putValue("Function", null);
        this.selectedDirectory = null;
    }

    public File getSelectedDirectory() {
        return this.selectedDirectory;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PerformingFileContainer fileContainer = new PerformingFileContainer(){

            public boolean perform() {
                if (super.getFile() != null) {
                    if (!super.getFile().isDirectory()) {
                        BackupButtonAction.this.dialogHandler.showBackupErrorDialog();
                    } else {
                        BackupButtonAction.this.selectedDirectory = super.getFile();
                        BackupButtonAction.this.putValue("Function", BackupButtonAction.this.selectedDirectory.getAbsolutePath());
                    }
                }
                return super.perform();
            }
        };
        this.filePersistence.saveFile((FileContainer)fileContainer, this.fileSelector);
    }

    private static class RegistrationFileFilter
    extends URFileFilter {
        private final TextResource textResource;

        RegistrationFileFilter(TextResource textResource) {
            this.textResource = textResource;
        }

        public String getFileExtension() {
            return "Z_Z";
        }

        public String getDescription() {
            return this.textResource.backupFiles();
        }
    }
}

