/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.backuprestore.filemanager;

import com.ur.disk.Directories;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.backuprestore.filemanager.DialogHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.inject.Inject;
import javax.swing.AbstractAction;

public class RestoreButtonAction
extends AbstractAction {
    private final transient FilePersistence filePersistence;
    private final transient FileManagerConfiguration fileSelector;
    private transient File selectedBackupFile;
    private transient DialogHandler dialogHandler;

    @Inject
    RestoreButtonAction(FilePersistence filePersistence, TextResource textResource, DialogHandler dialogHandler) {
        this.filePersistence = filePersistence;
        this.dialogHandler = dialogHandler;
        this.fileSelector = new FileManagerConfiguration(textResource.selectLocation(), FileManagerConfiguration.Access.RESTRICTED, Directories.programs(), false, new URFileFilter[]{new RegistrationFileFilter(textResource)});
        this.initActionProperties();
    }

    private void initActionProperties() {
        this.putValue("Function", null);
        this.selectedBackupFile = null;
    }

    public File getSelectedBackupFile() {
        return this.selectedBackupFile;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PerformingFileContainer fileContainer = new PerformingFileContainer(){

            public boolean perform() {
                if (super.getFile() != null) {
                    File selectedFile = super.getFile();
                    if (!RestoreButtonAction.this.validateFile(selectedFile)) {
                        RestoreButtonAction.this.dialogHandler.showRestoreErrorDialog();
                        RestoreButtonAction.this.selectedBackupFile = new File("invalid file");
                        RestoreButtonAction.this.putValue("Function", "");
                    } else {
                        RestoreButtonAction.this.selectedBackupFile = super.getFile();
                        RestoreButtonAction.this.putValue("Function", RestoreButtonAction.this.selectedBackupFile.getAbsolutePath());
                    }
                }
                return super.perform();
            }
        };
        this.filePersistence.openFile((FileContainer)fileContainer, this.fileSelector);
    }

    private boolean validateFile(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getName().endsWith(".urb");
    }

    private static class RegistrationFileFilter
    extends URFileFilter {
        private final TextResource textResource;

        RegistrationFileFilter(TextResource textResource) {
            this.textResource = textResource;
        }

        public boolean accept(File f) {
            return super.accept(f);
        }

        public String getFileExtension() {
            return "urb";
        }

        public String getDescription() {
            return this.textResource.backupFiles();
        }
    }
}

