/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.firmwareupdate;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.polyscope.system.impl.firmwareupdate.FirmwareUpdateListener;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class FirmwareUpdateMessageConsumer
implements RobotMessageConsumer {
    private EventManager eventManager;

    @Inject
    private FirmwareUpdateMessageConsumer(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public boolean sendNotification() {
        return false;
    }

    public int consume(DataInput stream, int messageLength, RobotMessage robotMessage) throws IOException {
        final int firmwareUpdateAttempt = stream.readUnsignedByte();
        final int firmwareUpdatePercentComplete = stream.readUnsignedByte();
        this.eventManager.fireEvent(FirmwareUpdateListener.class, (NotificationStrategy)new NotificationStrategy<FirmwareUpdateListener>(){

            public void notify(FirmwareUpdateListener listener) {
                listener.updateStatus(firmwareUpdateAttempt, firmwareUpdatePercentComplete);
            }
        });
        return 2;
    }
}

