/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.firmwareupdate;

import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.firmwareupdate.FirmwareUpdateListener;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.event.EventManager;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import javax.inject.Inject;

public class FirmwareUpdateNotifier
implements FirmwareUpdateListener {
    private static final byte MAX_FIRMWARE_UPDATE_ATTEMPTS = 3;
    private final TaskMonitor taskMonitor;
    private int lastSeenFirmwareUpdateAttempt = -1;
    private Future<?> firmwareProgress;
    private boolean firmwareUpdateMessageReceived;
    private ErrorDialogCreator errorDialogCreator;
    private TextResource textResource;

    @Inject
    public FirmwareUpdateNotifier(TaskMonitor taskMonitor, EventManager eventManager, ErrorDialogCreator errorDialogCreator, TextResource textResource) {
        this.taskMonitor = taskMonitor;
        this.errorDialogCreator = errorDialogCreator;
        this.textResource = textResource;
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                if (!FirmwareUpdateNotifier.this.firmwareUpdateMessageReceived) {
                    FirmwareUpdateNotifier.this.closeProgressBar();
                }
                FirmwareUpdateNotifier.this.firmwareUpdateMessageReceived = false;
            }
        }, new Date(), 1000L);
        eventManager.addStrongListener(FirmwareUpdateListener.class, (Object)this);
    }

    @Override
    public void updateStatus(int firmwareUpdateAttempt, int firmwareUpdatePercentComplete) {
        this.firmwareUpdateMessageReceived = true;
        if (firmwareUpdateAttempt > 3) {
            this.showFirmwareUpdateFailure();
        } else if (firmwareUpdatePercentComplete >= 100) {
            this.showFirmwareUpdateSuccess();
        } else {
            this.showFirmwareUpdateProgress(firmwareUpdateAttempt, firmwareUpdatePercentComplete);
        }
    }

    private void showFirmwareUpdateProgress(int attempt, int percentComplete) {
        if (this.firmwareProgress == null || attempt != this.lastSeenFirmwareUpdateAttempt) {
            this.lastSeenFirmwareUpdateAttempt = attempt;
            String title = this.lastSeenFirmwareUpdateAttempt == 1 ? this.textResource.UpdatingJointFirmware() : this.textResource.UpdatingJointFirmwareWithAttempt(this.lastSeenFirmwareUpdateAttempt, 3);
            this.firmwareProgress = this.taskMonitor.start(title, percentComplete);
        }
        this.taskMonitor.increaseProgress();
    }

    private void showFirmwareUpdateSuccess() {
        this.closeProgressBar();
    }

    private void showFirmwareUpdateFailure() {
        this.closeProgressBar();
        ErrorMessage errorMessage = new ErrorMessage(this.textResource.firmwareUpdateFailureTitle(), this.textResource.firmwareUpdateFailureExplanation(), this.textResource.firmwareUpdateFailureSuggestion());
        this.errorDialogCreator.showErrorDialog(errorMessage, null);
    }

    private void closeProgressBar() {
        if (this.firmwareProgress != null) {
            this.taskMonitor.stop(this.firmwareProgress);
            this.firmwareProgress = null;
        }
    }
}

