/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install;

import com.ur.lang.IOUtil;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.install.FileLoad;
import com.ur.polyscope.system.impl.install.InstallerBase;
import com.ur.polyscope.system.impl.install.webupdate.SoftwareUpdateDescriptionSimple;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Installer
extends InstallerBase
implements Runnable {
    private static final String INSTALL_UPDATE_SCRIPT = "urupdate --update";
    private PrintStream opw = null;
    private ByteArrayOutputStream errorOutputStream = null;
    private final Thread thr;
    private FileLoad fileLoad;
    private final TextResource textResource;
    private final MessageDialogCreator messageDialogCreator;

    public Installer(SoftwareUpdateDescriptionSimple wc, TextResource textResource, MessageDialogCreator messageDialogCreator) {
        this.textResource = textResource;
        this.messageDialogCreator = messageDialogCreator;
        this.setConfig(wc);
        this.thr = new Thread((Runnable)this, "SoftwareInstallerThread");
        this.tieOutput(null);
        this.fileLoad = null;
    }

    @Override
    public void downloadData() {
        this.fireOnDownloadComplete();
    }

    @Override
    public void run() {
        try {
            this.runCommand("urupdate --update " + this.getSoftwareUpgradeDescription().getFilename());
        }
        catch (Exception e) {
            this.handleScriptError();
        }
    }

    private void handleScriptError() {
        this.messageDialogCreator.showMessageDialog((DialogMessage)new ErrorMessage(this.textResource.error(), this.textResource.updateScriptErrorOccured()), MessageDialogType.ERROR, new OkDialogListener(){

            public void onClick(DialogReturnValue returnValue) {
                Installer.this.fireFailed();
            }
        });
    }

    @Override
    public void start() {
        this.thr.start();
    }

    public void tieOutput(PrintStream pw) {
        IOUtil.close((Closeable)this.opw);
        this.opw = pw == null ? System.out : pw;
    }

    private int waitFor(Process proc) {
        this.errorOutputStream = new ByteArrayOutputStream();
        block6: while (true) {
            try {
                while (true) {
                    int read;
                    BufferedReader ebr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    BufferedReader obr = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while (ebr.ready()) {
                        read = ebr.read();
                        this.opw.print("" + (char)read);
                        this.opw.flush();
                        this.errorOutputStream.write((char)read);
                        this.errorOutputStream.flush();
                    }
                    while (obr.ready()) {
                        read = obr.read();
                        this.opw.print("" + (char)read);
                        this.opw.flush();
                        this.errorOutputStream.write((char)read);
                        this.errorOutputStream.flush();
                    }
                    try {
                        return proc.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        try {
                            Thread.sleep(100L);
                            continue block6;
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void abortInstallation() {
        if (this.fileLoad != null) {
            this.fileLoad.cleanupResources();
        }
    }

    private void runCommand(String command) throws IOException, BashException {
        int i = this.waitFor(Runtime.getRuntime().exec(command));
        if (i != 0) {
            throw new BashException();
        }
    }

    private class BashException
    extends Exception {
        private BashException() {
        }
    }
}

