/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install;

import com.ur.polyscope.system.impl.install.InstallerListener;
import com.ur.polyscope.system.impl.install.webupdate.SoftwareUpdateDescriptionSimple;
import java.util.ArrayList;

public abstract class InstallerBase {
    private final ArrayList<InstallerListener> installListenerList = new ArrayList();
    protected SoftwareUpdateDescriptionSimple softwareUpgradeDescription;

    public void addInstallerListener(InstallerListener installListener) {
        if (installListener == null) {
            throw new NullPointerException("installer listener cannot be null");
        }
        this.installListenerList.add(installListener);
    }

    protected void fireOnUpdate(int completeness, String downloadStateString) {
        for (InstallerListener installListener : this.installListenerList) {
            installListener.onUpdate(completeness, downloadStateString, this);
        }
    }

    protected void fireOnComplete() {
        for (InstallerListener installListener : this.installListenerList) {
            installListener.onComplete(this);
        }
    }

    protected void fireOnDownloadComplete() {
        for (InstallerListener installListener : this.installListenerList) {
            installListener.onDownloadComplete(this);
        }
    }

    protected boolean fireTestRestart() {
        for (InstallerListener installListener : this.installListenerList) {
            if (!installListener.requestRestart(this)) continue;
            return true;
        }
        return false;
    }

    protected boolean fireTestReboot() {
        for (InstallerListener installListener : this.installListenerList) {
            if (!installListener.requestReboot(this)) continue;
            return true;
        }
        return false;
    }

    public void fireFailed() {
        for (InstallerListener installListener : this.installListenerList) {
            installListener.onFailed(this.softwareUpgradeDescription.getFilename());
        }
    }

    public abstract void downloadData() throws InterruptedException;

    public abstract void start();

    public abstract void abortInstallation();

    public SoftwareUpdateDescriptionSimple getSoftwareUpgradeDescription() {
        return this.softwareUpgradeDescription;
    }

    public void setConfig(SoftwareUpdateDescriptionSimple softwareUpgradeDescription) {
        this.softwareUpgradeDescription = softwareUpgradeDescription;
    }
}

