/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import com.ur.polyscope.system.impl.install.FileLoad;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class FileDownload
implements FileLoad,
Runnable {
    private long currentlyDownloaded;
    private long remoteFileSize;
    InputStream is;
    OutputStream os;
    private Thread thread;
    boolean hasData = false;
    private File tarFile;
    private File localFile;

    FileDownload(URL name, File localfile) throws IOException {
        try {
            this.tarFile = new File(name.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        URLConnection conn = name.openConnection();
        this.is = conn.getInputStream();
        this.remoteFileSize = conn.getContentLength();
        this.localFile = localfile;
        this.deleteLocalFile();
        this.os = new FileOutputStream(this.localFile);
        this.setCurrentlyDownloaded(0L);
    }

    @Override
    public void cleanupResources() {
        this.deleteLocalFile();
        this.deleteTarFile();
    }

    void start() {
        this.thread = new Thread((Runnable)this, "FileDownloadThread");
        this.hasData = true;
        this.thread.start();
    }

    @Override
    public int getPercentageComplete() {
        long currentlyDownloaded = this.getCurrentlyDownloaded();
        if (currentlyDownloaded < 0L) {
            return -1;
        }
        if (this.remoteFileSize != 0L) {
            return (int)(100L * currentlyDownloaded / this.remoteFileSize);
        }
        return 100;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] data = new byte[1000];
        try {
            while (this.hasData) {
                try {
                    int i = this.is.read(data);
                    if (i == -1) {
                        this.hasData = false;
                        continue;
                    }
                    this.setCurrentlyDownloaded(this.getCurrentlyDownloaded() + (long)i);
                    this.os.write(data, 0, i);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.hasData = false;
                    this.setCurrentlyDownloaded(-1L);
                }
            }
            return;
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteLocalFile() {
        if (this.localFile.exists()) {
            this.localFile.delete();
        }
    }

    private void deleteTarFile() {
        if (this.tarFile != null && this.tarFile.exists()) {
            this.tarFile.delete();
        }
    }

    private synchronized void setCurrentlyDownloaded(long currentlyDownloaded) {
        this.currentlyDownloaded = currentlyDownloaded;
    }

    private synchronized long getCurrentlyDownloaded() {
        return this.currentlyDownloaded;
    }
}

