/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import com.ur.polyscope.system.impl.install.FileLoad;
import com.ur.polyscope.system.impl.install.LocalFileLoad;
import com.ur.polyscope.system.impl.install.webupdate.FileDownload;
import com.ur.polyscope.system.impl.install.webupdate.XMLElement;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class SoftwareUpdateDescription
implements Comparable<SoftwareUpdateDescription> {
    private String description;
    private URVersion version;
    private String tarFilename;
    private String path;
    private boolean isDebug;
    private String server;
    private String title;
    private boolean isUrupFile;

    public void setAsFile(String path) {
        this.path = path;
        this.server = "";
    }

    public void setIsUrupFile(boolean isUrpFile) {
        this.isUrupFile = isUrpFile;
    }

    SoftwareUpdateDescription(XMLElement elem) {
        XMLElement elemVersion;
        if (elem.has("description")) {
            this.description = elem.get("description").getText();
        }
        if ((elemVersion = elem.get("version")).getAttrib("revision") != null) {
            int major = elemVersion.getAttribAsInt("major");
            int minor = elemVersion.getAttribAsInt("minor");
            int bugfix = elemVersion.getAttribAsInt("revision");
            this.version = new URVersion(major, minor, bugfix);
        } else {
            int major = elemVersion.getAttribAsInt("major");
            int minor = elemVersion.getAttribAsInt("minor");
            int build = elemVersion.getAttribAsInt("build");
            this.version = new URVersion(major, minor, build);
        }
        if (elem.has("debug")) {
            Log.debug((String)("Element with version " + this.version + " is a debug version"));
            this.isDebug = true;
        } else {
            this.isDebug = false;
        }
        this.tarFilename = elem.get("tarfile").getText();
        this.path = "";
        this.server = elem.has("server") ? elem.get("server").getText() : "";
        this.title = elem.get("title").getText();
    }

    public FileLoad retrieveConfiguration() {
        FileLoad result = null;
        try {
            if (this.server.equals("")) {
                if (this.isUrupFile) {
                    File tmpDir = FileUtils.createTempDir();
                    try {
                        BashScriptRunner bs = new BashScriptRunner("bash " + this.path + " --unpack " + tmpDir.getCanonicalPath());
                        bs.addEnvVar("RUR", "UvxiDl3g7uw2MdCmyNqdgB80PSxP4HCt4tr1IJtoIEP");
                        bs.execute();
                        if (bs.getReturnVal() != 0) {
                            Log.error((String)("Failed to unpack: " + this.path));
                            File file = new File(tmpDir.getCanonicalPath() + File.separator + this.tarFilename);
                            if (file.exists()) {
                                file.delete();
                            }
                            return null;
                        }
                        BashScriptRunner mover = new BashScriptRunner("mv " + tmpDir.getCanonicalPath() + File.separator + this.tarFilename + " /tmp/");
                        mover.execute();
                        if (mover.getReturnVal() == 0) {
                            result = new LocalFileLoad(new File("/tmp/" + this.tarFilename));
                        }
                    }
                    catch (Exception e) {
                        Log.error((String)(this.path + " --unpack script: "), (Throwable)e);
                    }
                } else {
                    result = new LocalFileLoad(new File(this.path + File.separator + this.tarFilename));
                }
            } else {
                URL urlTarFile = new URL(this.server + File.separator + this.tarFilename);
                File fl = new File("/tmp/" + this.tarFilename);
                fl.delete();
                result = new FileDownload(urlTarFile, fl);
                ((FileDownload)result).start();
            }
            return result;
        }
        catch (MalformedURLException e) {
            Log.error((String)"", (Throwable)e);
        }
        catch (IOException e) {
            Log.error((String)"", (Throwable)e);
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public URVersion getVersion() {
        return this.version;
    }

    public String getTarFilename() {
        return this.tarFilename;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    @Override
    public int compareTo(SoftwareUpdateDescription otherUpdateDescription) {
        return this.version.compareTo(otherUpdateDescription.getVersion());
    }

    public String toString() {
        String str = this.title + " " + this.version;
        if (this.isDebug()) {
            str = str + " (B)";
        }
        return str;
    }

    public String getPath() {
        return this.path;
    }
}

