/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import com.ur.polyscope.system.impl.install.webupdate.SoftwareUpdateDescription;
import com.ur.polyscope.system.impl.install.webupdate.XMLDocument;
import com.ur.polyscope.system.impl.install.webupdate.XMLElement;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SoftwareUpdateDescriptionList {
    private List<SoftwareUpdateDescription> vconfs = new ArrayList<SoftwareUpdateDescription>();

    public void addConfigurationsFromFile(File f) {
        try {
            this.addFileConfigurations(f, null);
        }
        catch (IOException e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public void addConfigurationsFromUrupFile(File f, File urupFileDir) {
        try {
            this.addFileConfigurations(f, urupFileDir);
        }
        catch (IOException e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    private void addFileConfigurations(File f, File urupFile) throws IOException {
        XMLDocument doc = new XMLDocument(f);
        XMLElement rootElem = doc.getRoot();
        int numConfigs = rootElem.get("number-of-configs").getAttribAsInt("value");
        for (int i = 0; i < numConfigs; ++i) {
            SoftwareUpdateDescription sud = new SoftwareUpdateDescription(rootElem.get("configuration", "id", Integer.toString(i)));
            if (urupFile != null) {
                sud.setAsFile(urupFile.getCanonicalPath());
                sud.setIsUrupFile(true);
            } else {
                sud.setAsFile(f.getParentFile().getCanonicalPath());
                sud.setIsUrupFile(false);
            }
            this.vconfs.add(sud);
        }
    }

    public List<SoftwareUpdateDescription> getConfigurations() {
        return this.vconfs;
    }
}

