/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import com.ur.lang.StringUtils;
import com.ur.polyscope.system.impl.install.webupdate.SoftwareUpdateDescriptionSimple;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.List;

public class SoftwareUpdateDescriptionListSimple {
    private static final String FILE_NAME_EXTENSION = ".urup";
    private static final String VERSION_DELIMITER = "ver.";
    private static final String LINE_DELIMITER = "\n";
    private List<SoftwareUpdateDescriptionSimple> files = new ArrayList<SoftwareUpdateDescriptionSimple>();

    public static List<SoftwareUpdateDescriptionSimple> buildFromScriptOutput(String outputLines) {
        String[] line;
        ArrayList<SoftwareUpdateDescriptionSimple> result = new ArrayList<SoftwareUpdateDescriptionSimple>();
        for (String li : line = outputLines.split(LINE_DELIMITER)) {
            try {
                int indexOfFileNameExtension;
                if (StringUtils.numberOfOccurances((String)FILE_NAME_EXTENSION, (String)li) != 1 || (indexOfFileNameExtension = li.indexOf(FILE_NAME_EXTENSION)) <= 0) continue;
                String filename = li.substring(0, indexOfFileNameExtension + FILE_NAME_EXTENSION.length()).trim();
                String description = li.substring(indexOfFileNameExtension + FILE_NAME_EXTENSION.length()).trim();
                if (StringUtils.numberOfOccurances((String)VERSION_DELIMITER, (String)description) != 1) continue;
                String versionString = description.substring(description.indexOf(VERSION_DELIMITER) + VERSION_DELIMITER.length()).trim();
                URVersion version = SoftwareUpdateDescriptionListSimple.getVersion(versionString);
                result.add(new SoftwareUpdateDescriptionSimple(filename, description, version));
            }
            catch (Exception ex) {
                Log.error((String)"", (Throwable)ex);
            }
        }
        return result;
    }

    private static URVersion getVersion(String versionString) {
        if (versionString.contains("-")) {
            versionString = versionString.replace("-", ".");
        }
        return SoftwareUpdateDescriptionListSimple.getVersionWithoutDash(versionString);
    }

    private static URVersion getVersionWithoutDash(String versionString) {
        String[] split = versionString.split("\\.");
        int marketingMajor = Integer.parseInt(split[0]);
        int marketingMinor = Integer.parseInt(split[1]);
        int marketingPatch = Integer.parseInt(split[2]);
        return new URVersion(marketingMajor, marketingMinor, marketingPatch);
    }

    public List<SoftwareUpdateDescriptionSimple> getFiles() {
        return this.files;
    }

    public void addSimpleConfiguration(SoftwareUpdateDescriptionSimple softwareUpdateDescriptionSimple) {
        this.files.add(softwareUpdateDescriptionSimple);
    }
}

