/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import com.ur.polyscope.system.impl.install.webupdate.XMLElement;
import com.ur.util.logging.Log;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class XMLContentMapper
implements ContentHandler {
    Stack<XMLElement> stackElements = new Stack();
    int level = 0;
    private XMLElement currentElement = null;
    private XMLElement rootElement = null;

    XMLContentMapper() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement == null) {
            Log.error((String)"Current element cannot be null");
            return;
        }
        String str = new String(ch);
        str = str.substring(start, start + length);
        this.currentElement.addText(str);
    }

    public XMLElement getRoot() {
        return this.rootElement;
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        this.currentElement = !this.stackElements.isEmpty() ? this.stackElements.pop() : null;
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        XMLElement tempElement = new XMLElement(name, atts);
        if (this.currentElement != null) {
            this.currentElement.add(tempElement);
            this.stackElements.push(this.currentElement);
        } else {
            this.currentElement = tempElement;
            this.rootElement = tempElement;
        }
        this.currentElement = tempElement;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        Log.debug((String)("Prefix: " + prefix + " " + uri));
    }
}

