/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import com.ur.polyscope.system.impl.install.webupdate.URLGrabber;
import com.ur.polyscope.system.impl.install.webupdate.XMLContentMapper;
import com.ur.polyscope.system.impl.install.webupdate.XMLElement;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLDocument {
    private XMLElement root;

    public XMLDocument(String url) throws MalformedURLException, IOException {
        try {
            InputStream data = URLGrabber.getDocumentAsInputStream(url);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            XMLContentMapper ch = new XMLContentMapper();
            parser.setContentHandler(ch);
            parser.parse(new InputSource(data));
            this.root = ch.getRoot();
        }
        catch (SAXException e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public XMLDocument(File f) throws IOException {
        try {
            FileInputStream data = new FileInputStream(f);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            XMLContentMapper ch = new XMLContentMapper();
            parser.setContentHandler(ch);
            parser.parse(new InputSource(data));
            this.root = ch.getRoot();
        }
        catch (SAXException e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public XMLDocument(String s, boolean dummy) throws IOException {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            XMLContentMapper ch = new XMLContentMapper();
            parser.setContentHandler(ch);
            parser.parse(new InputSource(new StringReader(s)));
            this.root = ch.getRoot();
        }
        catch (SAXException e) {
            Log.error((String)"", (Throwable)e);
        }
    }

    public XMLElement getRoot() {
        return this.root;
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + this.root.toXML();
    }
}

