/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.install.webupdate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;

public class XMLElement
implements Collection<XMLElement> {
    private HashMap<String, String> attributes = new HashMap();
    private String name;
    private Vector<XMLElement> subElements = new Vector();
    private String theText = "";

    public XMLElement(String name, Attributes atts) {
        this.name = name;
        if (atts.getLength() != 0) {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.attributes.put(atts.getLocalName(i), atts.getValue(i));
            }
        }
    }

    @Override
    public boolean add(XMLElement e) {
        return this.subElements.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends XMLElement> c) {
        return this.subElements.addAll(c);
    }

    @Override
    public void clear() {
        this.subElements.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.subElements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.subElements.containsAll(c);
    }

    public XMLElement get(String id) throws IndexOutOfBoundsException {
        if (this.hasChildren()) {
            for (XMLElement elm : this.subElements) {
                if (!elm.getName().equals(id)) continue;
                return elm;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public XMLElement get(String elmName, String attribName, String attribValue) throws IndexOutOfBoundsException {
        if (this.hasChildren()) {
            for (XMLElement elm : this.subElements) {
                if (!elm.getName().equals(elmName) || elm.getAttrib(attribName) == null || !elm.getAttrib(attribName).equals(attribValue)) continue;
                return elm;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public String getAttrib(String string) {
        return this.attributes.get(string);
    }

    public boolean hasAttrib(String attribName) {
        return this.attributes.containsKey(attribName);
    }

    public int getAttribAsInt(String string) {
        if (this.attributes.containsKey(string)) {
            String s = this.attributes.get(string);
            return Integer.parseInt(s);
        }
        System.err.println("ERR: XMLElement " + this.name + " does not include the requested attribute " + string + ".");
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.theText.trim();
    }

    public boolean has(String element) {
        if (this.hasChildren()) {
            for (XMLElement elm : this.subElements) {
                if (!elm.getName().equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChildren() {
        return this.size() > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.subElements.isEmpty();
    }

    @Override
    public Iterator<XMLElement> iterator() {
        return this.subElements.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.subElements.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.subElements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.subElements.retainAll(c);
    }

    void addText(String substring) {
        this.theText = this.theText + substring;
    }

    @Override
    public int size() {
        return this.subElements.size();
    }

    @Override
    public Object[] toArray() {
        return this.subElements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.subElements.toArray(a);
    }

    public String toString() {
        String str = this.name + " {\n";
        if (!this.attributes.isEmpty()) {
            str = str + "  attribs(" + this.attributes.size() + "): {\n";
            for (String key : this.attributes.keySet()) {
                str = str + "    " + key + ": \"" + this.attributes.get(key) + "\"\n";
            }
            str = str + "  }\n";
        }
        if (this.getText().length() > 0) {
            str = str + "  text: \"" + this.getText() + "\"\n";
        }
        if (this.hasChildren()) {
            str = str + "  children [" + this.size() + "]\n";
        }
        str = str + "}";
        return str;
    }

    public String toXML() {
        String str = "<" + this.getName();
        if (!this.attributes.isEmpty()) {
            for (String key : this.attributes.keySet()) {
                str = str + " " + key + "=\"" + this.attributes.get(key) + "\"";
            }
        }
        if (this.getText().length() == 0 && !this.hasChildren()) {
            str = str + "/>";
            return str;
        }
        str = str + ">";
        if (this.getText().length() > 0) {
            str = str + this.getText();
        }
        if (this.hasChildren()) {
            str = str + "\n";
            for (XMLElement el : this) {
                str = str + el.toXML();
            }
        }
        str = str + "</" + this.getName() + ">\n";
        return str;
    }
}

