/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.internal;

import com.ur.polyscope.settings.SetupPanel;
import com.ur.polyscope.system.ShutdownVeto;
import com.ur.polyscope.system.impl.ImageResource;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.internal.OptionMessageProvider;
import com.ur.polyscope.system.impl.internal.ShutdownManager;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.dialog.OptionDialogListener;
import com.ur.swing.dialog.OptionMessage;
import com.ur.swing.dialog.OptionsDialogCreator;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class ShutdownAction
extends ShowScreenActionImpl {
    public static final String SHUTDOWN_ACTION = "shutdown.ShutdownAction";
    private final List<ShutdownVeto> shutdownVeto;
    private TextResource textResource;
    private final OptionsDialogCreator dialogCreator;

    @Inject
    public ShutdownAction(Set<ShutdownVeto> shutdownVeto, TextResource textResource, OptionsDialogCreator dialogCreator) {
        super(SetupPanel.class, null, true);
        this.shutdownVeto = new ArrayList<ShutdownVeto>(shutdownVeto);
        this.textResource = textResource;
        Collections.sort(this.shutdownVeto, new Comparator<ShutdownVeto>(){

            @Override
            public int compare(ShutdownVeto item1, ShutdownVeto item2) {
                return item1.getClass().toString().compareTo(item2.getClass().toString());
            }
        });
        this.dialogCreator = dialogCreator;
        this.putValue("Name", textResource.shutdownRobot());
        this.putValue("InternalName", SHUTDOWN_ACTION);
        this.initValues();
    }

    private void initValues() {
        this.putValue("SmallIcon", ImageResource.powerWhite());
        this.putValue("SelectedSmallIcon", ImageResource.powerBlack());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
    }

    public void actionPerformed(ActionEvent e) {
        OptionMessage optionMessage = new OptionMessageProvider(this.textResource).selectShutdownOrRestart();
        OptionDialogListener optionDialogListener = new OptionDialogListener(){

            public void onOption1Clicked() {
                new Thread("Shutdown Thread"){

                    @Override
                    public void run() {
                        if (ShutdownAction.this.isReadyToShutdown()) {
                            ShutdownManager.shutdown();
                        }
                    }
                }.start();
            }

            public void onOption2Clicked() {
                new Thread("Shutdown Thread"){

                    @Override
                    public void run() {
                        if (ShutdownAction.this.isReadyToShutdown()) {
                            ShutdownManager.reboot();
                        }
                    }
                }.start();
            }
        };
        this.dialogCreator.showOptionMessageDialog(optionMessage, optionDialogListener);
    }

    public void gracefulRestartGUI() {
        new Thread("Restart GUI Thread"){

            @Override
            public void run() {
                if (ShutdownAction.this.isReadyToShutdown()) {
                    ShutdownManager.restartGui();
                }
            }
        }.start();
    }

    private boolean isReadyToShutdown() {
        for (ShutdownVeto each : this.shutdownVeto) {
            if (each.canShutdown()) continue;
            return false;
        }
        return true;
    }
}

