/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.internal;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.system.ShutdownListener;
import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.system.impl.internal.ShutdownAction;
import com.ur.polyscope.system.impl.internal.ShutdownManager;
import com.ur.swing.InterceptableAction;
import com.ur.util.event.EventNotificationService;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;

@Singleton
public class ShutdownServiceImpl
implements ShutdownService {
    private static final Logger LOG = LogFactory.createLogger(ShutdownManager.class);
    private final ShutdownAction shutdownAction;

    @Inject
    public ShutdownServiceImpl(ShutdownAction shutdownAction, Privileges privileges, LockActionCreator actionForPrivilegeDecorator) {
        this.shutdownAction = (ShutdownAction)actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)shutdownAction, privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.SHUTDOWN));
        Thread shutdownThread = new Thread(() -> {
            switch (ShutdownManager.exitCode) {
                case -1: 
                case 10: 
                case 387: {
                    ShutdownServiceImpl.notifyShutdown();
                    break;
                }
                case 0: {
                    ShutdownServiceImpl.notifyRestart();
                    break;
                }
                default: {
                    LOG.warn("Unknown shutdown sequence initiated " + ShutdownManager.exitCode, new Object[0]);
                    ShutdownServiceImpl.notifyShutdown();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    private static void notifyShutdown() {
        EventNotificationService.notify(ShutdownListener.class, ShutdownListener::shutdownStarted);
    }

    private static void notifyRestart() {
        EventNotificationService.notify(ShutdownListener.class, ShutdownListener::restartStarted);
    }

    public void requestShutdown() {
        SwingUtilities.invokeLater(() -> this.shutdownAction.actionPerformed(null));
    }

    public void forceShutdown() {
        SwingUtilities.invokeLater(new ShutdownManager.ForceShutdown());
    }

    public void requestRestartGui() {
        SwingUtilities.invokeLater(ShutdownManager::restartGui);
    }

    public void requestGracefulRestartGUI() {
        SwingUtilities.invokeLater(this.shutdownAction::gracefulRestartGUI);
    }
}

