/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.language;

import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.system.impl.Settings;
import com.ur.polyscope.system.impl.internal.ShutdownManager;
import com.ur.swing.KeyboardLayouts;
import com.ur.swing.LanguageConfiguration;
import javax.inject.Inject;
import javax.inject.Provider;

public class ChinaForChina {
    private static final int FOR_CHINA = 1;
    private final Provider<RobotIdentification> provider;

    @Inject
    public ChinaForChina(Provider<RobotIdentification> provider) {
        this.provider = provider;
    }

    public boolean isForOutsideChina() {
        return !this.isForChina();
    }

    private boolean isForChina() {
        return ((RobotIdentification)this.provider.get()).getSerialNumber().getVariant() == 1;
    }

    public void validateLanguageSelectionOnSerialNumber(LanguageConfiguration.SupportedLanguage language, KeyboardLayouts keyboard) {
        boolean hasChanges = this.validateLanguageSelection(language, keyboard);
        if (hasChanges) {
            Settings.saveSettings();
        }
    }

    public void validateLanguageSelectionOnLoad(LanguageConfiguration.SupportedLanguage language, KeyboardLayouts keyboard) {
        boolean hasChanges = this.validateLanguageSelection(language, keyboard);
        if (hasChanges) {
            Settings.saveSettings();
            ShutdownManager.restartGui();
        }
    }

    private boolean validateLanguageSelection(LanguageConfiguration.SupportedLanguage language, KeyboardLayouts keyboard) {
        boolean hasChanges = false;
        if (this.isForChina() && language != LanguageConfiguration.SupportedLanguage.zh && language != LanguageConfiguration.SupportedLanguage.zt) {
            hasChanges = true;
            Settings.setLanguage(LanguageConfiguration.SupportedLanguage.zh);
        }
        if (this.isForChina() && keyboard != KeyboardLayouts.en) {
            hasChanges = true;
            Settings.setKeyboardLayout(KeyboardLayouts.en.name());
        }
        return hasChanges;
    }
}

