/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.language;

import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.language.LanguageSelectPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class LanguageSelectLayoutStrategy
implements LanguageSelectPanel.LayoutStrategy {
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private final ViewContext viewContext;
    private final TextResource textResource;

    @Inject
    public LanguageSelectLayoutStrategy(ViewContext viewContext) {
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
    }

    @Override
    public void applyLayoutTo(LanguageSelectPanel panel) {
        JPanel languageSelection = this.viewContext.createFormBuilder().component((JComponent)panel.languageSelectorComboBox, new FormBuilder.PanelConstraints[0]).spacer().end().component((JComponent)panel.englishProgrammingCheckBox, new FormBuilder.PanelConstraints[0]).end().getPanel();
        JPanel keyboardSelection = this.viewContext.createFormBuilder().component((JComponent)panel.keyboardLayout, new FormBuilder.PanelConstraints[0]).spacer().end().getPanel();
        panel.radioUnitsMetric.setText(this.textResource.metric());
        panel.radioUnitsUS.setText(this.textResource.imperial());
        JPanel unitSelection = this.viewContext.createFormBuilder().component((JComponent)panel.radioUnitsMetric, new FormBuilder.PanelConstraints[0]).spacer().spacer().end().component((JComponent)panel.radioUnitsUS, new FormBuilder.PanelConstraints[0]).end().getPanel();
        JPanel languageOptions = new JPanel(new BorderLayout(5, 0));
        languageOptions.setBackground(BETWEEN_CARD_COLOR);
        languageOptions.add((Component)this.createCard(this.textResource.systemLanguage(), languageSelection), "West");
        languageOptions.add((Component)this.createCard(this.textResource.keyboardLanguage(), keyboardSelection), "Center");
        JPanel restartPanel = panel.createRestartPanel(this.viewContext);
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setBackground(BETWEEN_CARD_COLOR);
        panel.setLayout(new BorderLayout(5, 5));
        panel.add(languageOptions, "North");
        panel.add(this.createCard(this.textResource.setupUnitsTitle(), unitSelection), "Center");
        panel.add(restartPanel, "South");
    }

    private JPanel createCard(String cardTitle, JPanel panel) {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder((Border)new CardBorder(cardTitle));
        result.add((Component)panel, "Center");
        return result;
    }
}

