/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.language;

import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.system.impl.ApplyAndRestartPanel;
import com.ur.polyscope.system.impl.Settings;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.language.ChinaForChina;
import com.ur.swing.KeyboardLayouts;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.units.UnitType;
import com.ur.util.event.EventManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class LanguageSelectPanel
extends ApplyAndRestartPanel {
    public static final String LANGUAGE_SELECTOR = "LanguageSelectPanel.languageSelector";
    public static final String KEYBOARD_SELECTOR = "LanguageSelectPanel.keyboardLayout";
    public static final String METRIC_UNITS = "LanguageSelectPanel.metricUnits";
    public static final String IMPERIAL_UNITS = "LanguageSelectPanel.imperialUnits";
    public static final String ENGLISH_PROGRAMMING = "LanguageSelectPanel.englishProgramming";
    private final TextResource textResource;
    private final ChinaForChina chinaForChina;
    private UnitType currentRadioUnits;
    private int chosenLanguage;
    public JCheckBox englishProgrammingCheckBox;
    public JComboBox languageSelectorComboBox;
    public JComboBox keyboardLayout;
    public JRadioButton radioUnitsMetric;
    public JRadioButton radioUnitsUS;

    @Inject
    public LanguageSelectPanel(TextResource textResource, LayoutStrategy layoutStrategy, ShutdownService shutdownService, EventManager eventManager, ChinaForChina chinaForChina) {
        super(shutdownService, eventManager);
        this.textResource = textResource;
        this.chinaForChina = chinaForChina;
        this.initComponents();
        this.finalizeComponents();
        layoutStrategy.applyLayoutTo(this);
    }

    private void finalizeComponents() {
        this.languageSelectorComboBox.setName(LANGUAGE_SELECTOR);
        this.keyboardLayout.setName(KEYBOARD_SELECTOR);
        this.radioUnitsMetric.setName(METRIC_UNITS);
        this.radioUnitsUS.setName(IMPERIAL_UNITS);
    }

    private DefaultComboBoxModel getLanguagesComboBoxModel() {
        DefaultComboBoxModel<LanguageConfiguration.SupportedLanguage> result = new DefaultComboBoxModel<LanguageConfiguration.SupportedLanguage>();
        for (LanguageConfiguration.SupportedLanguage each : LanguageConfiguration.SupportedLanguage.values()) {
            if (this.chinaForChina.isForOutsideChina()) {
                result.addElement(each);
                continue;
            }
            if (each != LanguageConfiguration.SupportedLanguage.zh && each != LanguageConfiguration.SupportedLanguage.zt) continue;
            result.addElement(each);
        }
        return result;
    }

    private ComboBoxModel getKeyboardLayouts() {
        DefaultComboBoxModel<KeyboardLayouts> result = new DefaultComboBoxModel<KeyboardLayouts>();
        for (KeyboardLayouts each : KeyboardLayouts.values()) {
            if (this.chinaForChina.isForOutsideChina()) {
                result.addElement(each);
                continue;
            }
            if (each != KeyboardLayouts.en) continue;
            result.addElement(each);
        }
        return result;
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        KeyboardLayouts layout = KeyboardLayouts.valueOf((String)Settings.getKeyboardLayout());
        this.keyboardLayout.setSelectedItem(layout);
        this.restartNowButton.setEnabled(false);
    }

    private void updateEnglishProgrammingEnabled() {
        if (this.isEnglishLanguage()) {
            this.englishProgrammingCheckBox.setEnabled(false);
            this.englishProgrammingCheckBox.setSelected(true);
        } else {
            this.englishProgrammingCheckBox.setEnabled(true);
            if (this.languageSelectorComboBox.getSelectedIndex() == this.chosenLanguage) {
                this.englishProgrammingCheckBox.setSelected(Settings.getIsUsingEnglishProgramming());
            } else {
                this.englishProgrammingCheckBox.setSelected(false);
            }
        }
    }

    private boolean isEnglishLanguage() {
        boolean isForOutsideChina = this.chinaForChina.isForOutsideChina();
        boolean isFirstTwoLanguages = this.languageSelectorComboBox.getSelectedIndex() == 0 || this.languageSelectorComboBox.getSelectedIndex() == 1;
        return isForOutsideChina && isFirstTwoLanguages;
    }

    protected void initComponents() {
        super.createApplyAndRestartButton(this.textResource);
        this.languageSelectorComboBox = new JComboBox();
        this.languageSelectorComboBox.setModel(this.getLanguagesComboBoxModel());
        this.languageSelectorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LanguageSelectPanel.this.languageSelectorComboBoxItemStateChanged();
                LanguageSelectPanel.this.updateRestartButton();
            }
        });
        this.keyboardLayout = new JComboBox();
        this.keyboardLayout.setModel(this.getKeyboardLayouts());
        this.keyboardLayout.addItemListener(e -> {
            KeyboardLayouts layout = (KeyboardLayouts)e.getItem();
            if (layout == null) {
                return;
            }
            Settings.setKeyboardLayout(layout.name());
            this.updateRestartButton();
        });
        this.englishProgrammingCheckBox = new JCheckBox();
        this.englishProgrammingCheckBox.setName(ENGLISH_PROGRAMMING);
        this.englishProgrammingCheckBox.setText("English programming");
        this.englishProgrammingCheckBox.addActionListener(evt -> this.updateRestartButton());
        this.radioUnitsMetric = new JRadioButton();
        this.radioUnitsMetric.setText(this.textResource.metricUnits());
        this.radioUnitsMetric.addActionListener(evt -> {
            this.radioUnitsMetricActionPerformed();
            this.updateRestartButton();
        });
        this.radioUnitsUS = new JRadioButton();
        this.radioUnitsUS.setText(this.textResource.usUnits());
        this.radioUnitsUS.addActionListener(evt -> {
            this.radioUnitsUSActionPerformed();
            this.updateRestartButton();
        });
        ButtonGroup unitsBG = new ButtonGroup();
        unitsBG.add(this.radioUnitsMetric);
        unitsBG.add(this.radioUnitsUS);
        this.languageSelectorComboBox.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                this.languageSelectorComboBox.setSelectedItem(Settings.getLanguage());
                this.englishProgrammingCheckBox.setSelected(Settings.getIsUsingEnglishProgramming());
                this.chosenLanguage = this.languageSelectorComboBox.getSelectedIndex();
                if (Settings.getUnits() == UnitType.US) {
                    this.radioUnitsUS.setSelected(true);
                    this.currentRadioUnits = UnitType.US;
                } else {
                    this.radioUnitsMetric.setSelected(true);
                    this.currentRadioUnits = UnitType.METRIC;
                }
                this.updateEnglishProgrammingEnabled();
                this.updateRestartButton();
            }
        });
        this.restartNowButton.setEnabled(false);
    }

    private void updateRestartButton() {
        this.restartNowButton.setEnabled(this.isRestartRequired());
    }

    private boolean isRestartRequired() {
        LanguageConfiguration.Region newRegion = LanguageConfiguration.Region.GLOBAL;
        LanguageConfiguration.SupportedLanguage language = (LanguageConfiguration.SupportedLanguage)this.languageSelectorComboBox.getSelectedItem();
        return language != Settings.getLanguage() || this.englishProgrammingCheckBox.isSelected() != Settings.getIsUsingEnglishProgramming() || this.currentRadioUnits != Settings.getUnits() || newRegion != Settings.getRegion();
    }

    @Override
    protected void applySettingsPerformed() {
        if (this.isRestartRequired()) {
            LanguageConfiguration.Region newRegion = LanguageConfiguration.Region.GLOBAL;
            LanguageConfiguration.SupportedLanguage language = (LanguageConfiguration.SupportedLanguage)this.languageSelectorComboBox.getSelectedItem();
            Settings.setLanguage(language);
            Settings.setUnits(this.currentRadioUnits);
            Settings.setRegion(newRegion);
            Settings.setUseEnglishProgramming(this.englishProgrammingCheckBox.isSelected());
            Settings.saveSettings();
        }
    }

    private void radioUnitsMetricActionPerformed() {
        this.currentRadioUnits = UnitType.METRIC;
    }

    private void radioUnitsUSActionPerformed() {
        this.currentRadioUnits = UnitType.US;
    }

    private void languageSelectorComboBoxItemStateChanged() {
        if (this.languageSelectorComboBox.getSelectedIndex() != this.chosenLanguage) {
            if (this.languageSelectorComboBox.getSelectedItem() == LanguageConfiguration.SupportedLanguage.us) {
                this.radioUnitsUS.setSelected(true);
                this.currentRadioUnits = UnitType.US;
            } else {
                this.radioUnitsMetric.setSelected(true);
                this.currentRadioUnits = UnitType.METRIC;
            }
        } else if (Settings.getUnits() == UnitType.US) {
            this.radioUnitsUS.setSelected(true);
            this.currentRadioUnits = UnitType.US;
        } else {
            this.radioUnitsMetric.setSelected(true);
            this.currentRadioUnits = UnitType.METRIC;
        }
        this.updateEnglishProgrammingEnabled();
        this.updateRestartButton();
    }

    public static interface LayoutStrategy {
        public void applyLayoutTo(LanguageSelectPanel var1);
    }
}

