/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network;

import com.ur.polyscope.system.impl.network.internal.NetworkStatistic;
import com.ur.polyscope.system.impl.network.internal.NetworkingService;
import javax.inject.Inject;

public class NetworkPresenter {
    private NetworkingService networkingService;

    @Inject
    public NetworkPresenter(NetworkingService networkingService) {
        this.networkingService = networkingService;
    }

    public NetworkViewModel getModel() {
        NetworkStatistic networkConfiguration = this.networkingService.getNetworkStatistics();
        String hostName = networkConfiguration.getHostName();
        String ipAddress = networkConfiguration.getAddress();
        NetworkViewModel.NetStatus status = this.getConnectionStatusText(networkConfiguration);
        return new NetworkViewModel(hostName, ipAddress, status);
    }

    private NetworkViewModel.NetStatus getConnectionStatusText(NetworkStatistic networkConfiguration) {
        if (networkConfiguration.isDisabled()) {
            return NetworkViewModel.NetStatus.DISABLED;
        }
        if (!networkConfiguration.isNetworkUp() || !this.networkingService.isConnected(networkConfiguration.getDns1())) {
            return NetworkViewModel.NetStatus.DISCONNECTED;
        }
        return NetworkViewModel.NetStatus.CONNECTED;
    }

    public static class NetworkViewModel {
        public final String hostName;
        public final String ipAddress;
        public final NetStatus status;

        public NetworkViewModel(String hostName, String ipAddress, NetStatus status) {
            this.hostName = hostName;
            this.ipAddress = ipAddress;
            this.status = status;
        }

        public static enum NetStatus {
            DISABLED,
            DISCONNECTED,
            CONNECTED;

        }
    }
}

