/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network.internal;

import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.network.NetworkPresenter;
import com.ur.swing.adapters.AncestorListenerAdapter;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.VerticalPlacementExtension;
import java.awt.Component;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

@Extension(value="AboutInfo")
public class DisplayHostNameExtension
implements VerticalPlacementExtension {
    private final NetworkPresenter presenter;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected JLabel hostname;
    private Future<?> hostnameUpdaterTask;

    @Inject
    public DisplayHostNameExtension(TextResource resource, NetworkPresenter presenter) {
        this.presenter = presenter;
        this.hostname = new JLabel("");
        this.hostname.putClientProperty("title", resource.hostname());
        this.hostname.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                DisplayHostNameExtension.this.updateHostNameText();
            }
        });
        this.updateHostNameText();
    }

    public VerticalPlacementExtension.PlacementContribution create() {
        return VerticalPlacementExtension.PlacementContribution.locateBefore((int)2000, (VerticalPlacementExtension.PlacementContribution)new VerticalPlacementExtension.PlacementContribution((Component)this.hostname));
    }

    private void updateHostNameText() {
        if (this.hostnameUpdaterTask == null || this.hostnameUpdaterTask.isDone()) {
            this.hostnameUpdaterTask = this.executorService.submit(new HostnameRunnable());
        }
    }

    private class HostnameRunnable
    implements Runnable {
        private HostnameRunnable() {
        }

        @Override
        public void run() {
            String hostName = ((DisplayHostNameExtension)DisplayHostNameExtension.this).presenter.getModel().hostName;
            SwingUtilities.invokeLater(() -> DisplayHostNameExtension.this.hostname.setText(hostName));
        }
    }
}

