/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network.internal;

import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.network.NetworkPresenter;
import com.ur.swing.SwingUtil;
import com.ur.swing.adapters.AncestorListenerAdapter;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.VerticalPlacementExtension;
import java.awt.Component;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

@Extension(value="AboutInfo")
public class DisplayIPAddressExtension
implements VerticalPlacementExtension {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final TextResource textResource;
    private final NetworkPresenter presenter;
    private Timer timer;
    private Future<?> ipUpdaterTask;
    protected final JLabel ipAddress;

    @Inject
    public DisplayIPAddressExtension(TextResource textResource, NetworkPresenter presenter) {
        this.textResource = textResource;
        this.presenter = presenter;
        this.ipAddress = new JLabel("0.0.0.0");
        this.ipAddress.putClientProperty("title", textResource.ipAddress());
        this.ipAddress.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                if (DisplayIPAddressExtension.this.timer != null) {
                    return;
                }
                DisplayIPAddressExtension.this.timer = new Timer();
                DisplayIPAddressExtension.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DisplayIPAddressExtension.this.updateIPText();
                    }
                }, 0L, 2000L);
            }

            public void ancestorRemoved(AncestorEvent event) {
                DisplayIPAddressExtension.this.timer.cancel();
                DisplayIPAddressExtension.this.timer = null;
            }
        });
        this.updateIPText();
    }

    private void updateIPText() {
        if (this.ipUpdaterTask == null || this.ipUpdaterTask.isDone()) {
            this.ipUpdaterTask = this.executorService.submit(new IPRunnable());
        }
    }

    public VerticalPlacementExtension.PlacementContribution create() {
        return VerticalPlacementExtension.PlacementContribution.locateBefore((int)2001, (VerticalPlacementExtension.PlacementContribution)new VerticalPlacementExtension.PlacementContribution((Component)this.ipAddress));
    }

    private class IPRunnable
    implements Runnable {
        private IPRunnable() {
        }

        @Override
        public void run() {
            String connectionStatusText = this.getConnectionStatusText(DisplayIPAddressExtension.this.presenter.getModel());
            SwingUtil.invokeAndWait(() -> DisplayIPAddressExtension.this.ipAddress.setText(connectionStatusText));
        }

        private String getConnectionStatusText(NetworkPresenter.NetworkViewModel model) {
            return String.format("%s %s", model.ipAddress, DisplayIPAddressExtension.this.textResource.networkStatus(model.status));
        }
    }
}

