/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network.internal;

import java.util.Map;
import java.util.Objects;

public class NetworkStatistic {
    public static final String NULL_IP_ADDRESS = "0.0.0.0";
    private final String hostName;
    private final Network netMode;
    private final boolean connected;
    private final String address;
    private final String netMask;
    private final String gateway;
    private final String dns1;
    private final String dns2;

    public NetworkStatistic(Map<String, String> networkSettings) {
        this.hostName = networkSettings.get("Hostname");
        this.netMode = Network.parse(networkSettings.get("Mode"));
        this.connected = "up".equalsIgnoreCase(networkSettings.get("Net"));
        this.address = this.ensureValidIp(networkSettings.get("Address"));
        this.netMask = this.ensureValidIp(networkSettings.get("Mask"));
        this.gateway = this.ensureValidIp(networkSettings.get("Gateway"));
        this.dns1 = this.ensureValidIp(networkSettings.get("nameserver1"));
        this.dns2 = this.ensureValidIp(networkSettings.get("nameserver2"));
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getIPMask() {
        return this.netMask;
    }

    public String getIPGateway() {
        return this.gateway;
    }

    public String getDns1() {
        return this.dns1;
    }

    public String getDns2() {
        return this.dns2;
    }

    public Network getNetworkMode() {
        return this.netMode;
    }

    public boolean isNetworkUp() {
        return this.connected;
    }

    private String ensureValidIp(String ip) {
        if (ip == null) {
            return NULL_IP_ADDRESS;
        }
        if (ip.split("\\.").length == 4) {
            return ip;
        }
        return NULL_IP_ADDRESS;
    }

    public boolean isDisabled() {
        return this.netMode.equals((Object)Network.DISABLED);
    }

    public boolean equals(Object obj) {
        if (obj == null || !NetworkStatistic.class.equals(obj.getClass())) {
            return false;
        }
        NetworkStatistic other = (NetworkStatistic)obj;
        return this.getNetworkMode() == other.getNetworkMode() && Objects.equals(this.getAddress(), other.getAddress()) && Objects.equals(this.getDns1(), other.getDns1()) && Objects.equals(this.getDns2(), other.getDns2()) && this.isNetworkUp() == other.isNetworkUp() && Objects.equals(this.getIPGateway(), other.getIPGateway()) && Objects.equals(this.getIPMask(), other.getIPMask()) && Objects.equals(this.getHostName(), other.getHostName());
    }

    public int hashCode() {
        return (this.getNetworkMode().name() + this.getAddress() + this.getDns1() + this.getDns2() + this.isNetworkUp() + this.getIPGateway() + this.getIPMask() + this.getHostName()).hashCode();
    }

    public static enum Network {
        STATIC,
        DHCP,
        DISABLED;


        private static Network parse(String mode) {
            if ("dhcp".equalsIgnoreCase(mode)) {
                return DHCP;
            }
            if ("static".equalsIgnoreCase(mode)) {
                return STATIC;
            }
            return DISABLED;
        }
    }
}

