/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network.internal;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.profinet.daemon.ProfinetDaemonState;
import com.ur.polyscope.profinet.installation.ProfinetService;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.system.impl.AbstractSystemPanel;
import com.ur.polyscope.system.impl.ImageResource;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.network.internal.NetworkStatistic;
import com.ur.polyscope.system.impl.network.internal.NetworkingService;
import com.ur.polyscope.system.impl.network.internal.StatusField;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NetworkingPanel
extends AbstractSystemPanel
implements AdminLockListener {
    private final NetworkingService networkingService;
    private final ProfinetService profinetService;
    private Timer t;
    List<NumberField> allIpField;
    private NumberField textAddress;
    private NumberField textMask;
    private NumberField textGateway;
    private NumberField textDNS1;
    private NumberField textDNS2;
    protected JLabel profinetLockedScreen;
    protected JRadioButton radioDHCP;
    protected JRadioButton radioStatic;
    protected JRadioButton radioDisabled;
    private StatusField statusField;
    private JButton applyStaticSettings;
    private JLabel isConnectedLabel;
    private EnumButtonGroup connectivityType;
    private ConnectedStatus disconnectedNetwork;
    private ConnectedStatus connectedNetwork;
    private boolean isLocked;

    @Inject
    public NetworkingPanel(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, NetworkingService networkingService, ProfinetService profinetService) {
        super(passwordFooter, viewContext);
        this.networkingService = networkingService;
        this.profinetService = profinetService;
        this.initComponents(viewContext);
        if (FeatureToggle.isActive((String)"systemPassword")) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    public void enter(Object o) {
        super.enter(o);
        this.updateNetworkingMode();
        this.t = new Timer("NetworkPanel.scheduler: Daemon", true);
        this.t.schedule((TimerTask)new UpdateNetworkStatistics(), 0L, 2000L);
    }

    @Override
    public Object exit() {
        this.t.cancel();
        this.t.purge();
        this.t = null;
        this.statusField.hideStatus();
        return super.exit();
    }

    public void doLock() {
        this.isLocked = true;
        if (!this.allowNetWorkChanges(this.profinetService.getProfinetDaemonState())) {
            return;
        }
        this.radioDHCP.setEnabled(false);
        this.radioStatic.setEnabled(false);
        this.radioDisabled.setEnabled(false);
        this.enableStaticNet(this.radioStatic.isSelected());
    }

    public void doUnlock() {
        this.isLocked = false;
        if (!this.allowNetWorkChanges(this.profinetService.getProfinetDaemonState())) {
            return;
        }
        this.radioDHCP.setEnabled(true);
        this.radioStatic.setEnabled(true);
        this.radioDisabled.setEnabled(true);
        this.enableStaticNet(this.radioStatic.isSelected());
    }

    private void updateNetworkingMode() {
        NetworkStatistic netInfo = this.networkingService.getNetworkStatistics();
        this.connectivityType.select((Enum)netInfo.getNetworkMode());
        this.enableStaticNet(this.radioStatic.isSelected());
        if (netInfo.isDisabled()) {
            this.setAsNullIpAndDisconnected();
        } else {
            this.updateTextFields(netInfo);
        }
        this.updateProfinetState(netInfo);
    }

    private void updateProfinetState(NetworkStatistic networkStatistic) {
        ProfinetDaemonState profinetDaemonState = this.profinetService.getProfinetDaemonState();
        if (this.allowNetWorkChanges(profinetDaemonState)) {
            this.profinetEnableUI(networkStatistic);
        } else {
            this.profinetDisableUI();
        }
    }

    private boolean allowNetWorkChanges(ProfinetDaemonState profinetDaemonState) {
        return profinetDaemonState == null || ProfinetDaemonState.STOPPED.equals((Object)profinetDaemonState);
    }

    private void profinetEnableUI(NetworkStatistic networkStatistic) {
        if (this.isLocked) {
            return;
        }
        NetworkStatistic.Network network = networkStatistic.getNetworkMode();
        this.enableStaticNet(NetworkStatistic.Network.STATIC.equals((Object)network));
        this.radioDHCP.setEnabled(true);
        this.radioDisabled.setEnabled(true);
        this.radioStatic.setEnabled(true);
        this.profinetLockedScreen.setVisible(false);
    }

    private void profinetDisableUI() {
        this.radioDHCP.setEnabled(false);
        this.radioDisabled.setEnabled(false);
        this.radioStatic.setEnabled(false);
        this.enableStaticNet(false);
        this.profinetLockedScreen.setVisible(true);
    }

    private void initComponents(ViewContext viewContext) {
        TextResource text = (TextResource)viewContext.getTextResource(TextResource.class);
        FormBuilder formBuilder = viewContext.createFormBuilder();
        this.disconnectedNetwork = new ConnectedStatus(ImageResource.gtkCancel(), text.networkNotConnected());
        this.connectedNetwork = new ConnectedStatus(ImageResource.gtkOk(), text.networkConnected());
        this.profinetLockedScreen = new JLabel(text.screenIsLocked());
        this.profinetLockedScreen.setIcon(ImageResource.formInformation());
        this.profinetLockedScreen.setVisible(false);
        this.radioDHCP = new JRadioButton(text.DHCP());
        this.radioStatic = new JRadioButton(text.staticAddress());
        this.radioDisabled = new JRadioButton(text.disabledNetwork());
        this.isConnectedLabel = new JLabel();
        this.textAddress = this.createTextField();
        this.textMask = this.createTextField();
        this.textGateway = this.createTextField();
        this.textDNS1 = this.createTextField();
        this.textDNS2 = this.createTextField();
        this.applyStaticSettings = new JButton();
        this.applyStaticSettings.setText(text.applySettings());
        this.applyStaticSettings.addActionListener(new ApplyStaticNetworkSettings());
        this.statusField = new StatusField();
        JPanel panel = formBuilder.headerLabel(text.setupNetwork(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.profinetLockedScreen, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label(text.selectYourNetworkMethod(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.radioDHCP, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.INDENT}).end().component((JComponent)this.radioStatic, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.INDENT}).end().component((JComponent)this.radioDisabled, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.INDENT}).end().label(this.isConnectedLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().sectionHeader(text.networkDetailedSettings(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().spacer().label(text.ipAddress(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.textAddress, new FormBuilder.PanelConstraints[0]).spacer().end().spacer().label(text.subnetMask(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.textMask, new FormBuilder.PanelConstraints[0]).spacer().end().spacer().label(text.defaultGateway(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.textGateway, new FormBuilder.PanelConstraints[0]).spacer().end().end().spacer().label(text.preferredDnsServer(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.textDNS1, new FormBuilder.PanelConstraints[0]).spacer().end().spacer().label(text.alternativeDnsServer(), new FormBuilder.PanelConstraints[0]).component((JComponent)this.textDNS2, new FormBuilder.PanelConstraints[0]).spacer().end().end().buttonRow((JComponent)this.applyStaticSettings, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().end().component((JComponent)this.statusField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().groupColumns(new int[]{2, 3}).getPanel();
        this.radioDHCP.addActionListener(e -> {
            this.enableStaticNet(false);
            this.networkingService.startDHCP();
        });
        this.radioStatic.addActionListener(e -> this.enableStaticNet(true));
        this.radioDisabled.addActionListener(e -> {
            this.setAsNullIpAndDisconnected();
            this.enableStaticNet(false);
            this.networkingService.disableNet();
        });
        this.connectivityType = new EnumButtonGroup(NetworkStatistic.Network.class);
        this.connectivityType.add((Enum)NetworkStatistic.Network.DHCP, (AbstractButton)this.radioDHCP);
        this.connectivityType.add((Enum)NetworkStatistic.Network.STATIC, (AbstractButton)this.radioStatic);
        this.connectivityType.add((Enum)NetworkStatistic.Network.DISABLED, (AbstractButton)this.radioDisabled);
        this.allIpField = Arrays.asList(this.textAddress, this.textMask, this.textGateway, this.textDNS1, this.textDNS2);
        this.setLayout(new BorderLayout());
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add(panel, "Center");
        this.addPasswordFooter();
        NetworkStatistic netInfo = this.networkingService.getNetworkStatistics();
        this.updateProfinetState(netInfo);
    }

    private void setAsNullIpAndDisconnected() {
        for (NumberField each : this.allIpField) {
            each.setText("0.0.0.0");
        }
        this.updateNetworkStatus(this.disconnectedNetwork);
    }

    private void enableStaticNet(boolean enabled) {
        if (this.isLocked) {
            enabled = false;
        }
        for (NumberField each : this.allIpField) {
            each.setEnabled(enabled);
        }
        this.applyStaticSettings.setEnabled(enabled);
    }

    private NumberField createTextField() {
        NumberField result = new NumberField();
        result.setEnabled(true);
        result.setEditable(true);
        result.setUnitWidth(0);
        result.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getIpAddressValidator()});
        result.setMode(Mode.IP_ADDRESS);
        return result;
    }

    private void updateTextFields(NetworkStatistic netInfo) {
        SwingUtil.invokeLater(() -> {
            if (netInfo == null || this.radioDisabled.isSelected()) {
                this.setAsNullIpAndDisconnected();
            } else {
                this.textAddress.setText(netInfo.getAddress());
                this.textMask.setText(netInfo.getIPMask());
                this.textGateway.setText(netInfo.getIPGateway());
                this.textDNS1.setText(netInfo.getDns1());
                this.textDNS2.setText(netInfo.getDns2());
            }
        });
    }

    private void updateNetworkStatus(ConnectedStatus status) {
        SwingUtil.invokeLater(() -> {
            this.isConnectedLabel.setIcon(status.icon);
            this.isConnectedLabel.setText(status.text);
        });
    }

    private class ApplyStaticNetworkSettings
    implements ActionListener {
        private ApplyStaticNetworkSettings() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NetworkingPanel.this.radioStatic.isSelected() && this.verifyStaticFields()) {
                NetworkingPanel.this.statusField.showStatus("");
                NetworkingPanel.this.networkingService.setFixedIP(NetworkingPanel.this.textAddress.getText(), NetworkingPanel.this.textMask.getText(), NetworkingPanel.this.textGateway.getText(), NetworkingPanel.this.textDNS1.getText(), NetworkingPanel.this.textDNS2.getText());
                NetworkingPanel.this.t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        NetworkingPanel.this.updateNetworkingMode();
                        NetworkingPanel.this.statusField.hideStatus();
                    }
                }, 2000L);
            }
        }

        private boolean verifyStaticFields() {
            JTextField[] fields;
            for (JTextField field : fields = new JTextField[]{NetworkingPanel.this.textAddress, NetworkingPanel.this.textMask, NetworkingPanel.this.textGateway, NetworkingPanel.this.textDNS1, NetworkingPanel.this.textDNS2}) {
                if (ValidationFactory.getIpAddressValidator().isValid(field.getText())) continue;
                return false;
            }
            return true;
        }
    }

    private static class ConnectedStatus {
        Icon icon;
        String text;

        public ConnectedStatus(Icon icon, String text) {
            this.icon = icon;
            this.text = text;
        }
    }

    private class UpdateNetworkStatistics
    extends TimerTask {
        private UpdateNetworkStatistics() {
        }

        @Override
        public void run() {
            if (NetworkingPanel.this.radioDisabled.isSelected()) {
                return;
            }
            NetworkStatistic netInfo = NetworkingPanel.this.networkingService.getNetworkStatistics();
            if (NetworkingPanel.this.radioDHCP.isSelected()) {
                NetworkingPanel.this.updateTextFields(netInfo);
            }
            NetworkingPanel.this.updateNetworkStatus(this.getConnectionStatus(netInfo));
        }

        private ConnectedStatus getConnectionStatus(NetworkStatistic netInfo) {
            ConnectedStatus status;
            if (NetworkingPanel.this.radioDisabled.isSelected()) {
                status = NetworkingPanel.this.disconnectedNetwork;
            } else {
                boolean isConnected = netInfo.isNetworkUp() && NetworkingPanel.this.networkingService.isConnected(netInfo.getDns1());
                status = isConnected ? NetworkingPanel.this.connectedNetwork : NetworkingPanel.this.disconnectedNetwork;
            }
            return status;
        }
    }
}

