/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network.internal;

import com.ur.polyscope.system.impl.network.internal.NetworkStatistic;
import com.ur.polyscope.system.impl.network.internal.NetworkUtils;
import com.ur.polyscope.system.impl.network.internal.NetworkingService;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import javax.inject.Inject;

public class NetworkingServiceNetStatistics
implements NetworkingService {
    private final NetworkUtils networkUtils;

    @Inject
    public NetworkingServiceNetStatistics(NetworkUtils networkUtils) {
        this.networkUtils = networkUtils;
    }

    @Override
    public void startDHCP() {
        this.executeBashScript("/sbin/easybot-controller --command-set-dhcp --command-set-interface=eth0");
    }

    @Override
    public void setFixedIP(String ip, String subnet, String gateway, String dns1, String dns2) {
        this.executeBashScript("/sbin/easybot-controller --command-set-netip=" + ip + ":" + subnet + ":" + gateway + ":" + dns1 + ":" + dns2 + ":" + "eth0");
    }

    @Override
    public void disableNet() {
        this.executeBashScript("/sbin/easybot-controller --command-set-netdown");
    }

    private void executeBashScript(String location) {
        BashScriptRunner bsr = new BashScriptRunner(location);
        bsr.executeBackground();
    }

    @Override
    public boolean isConnected(String address) {
        return this.networkUtils.isNetworkConnected(address);
    }

    @Override
    public NetworkStatistic getNetworkStatistics() {
        String[] rows;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String each : rows = this.getStatisticsFromScript().split("\n")) {
            String[] keyValuePair = this.getKeyValueFromRow(each);
            result.put(keyValuePair[0], keyValuePair[1]);
        }
        return new NetworkStatistic(result);
    }

    private String[] getKeyValueFromRow(String each) {
        String[] columns = each.split("[\\s,:]");
        if (columns.length == 2) {
            return columns;
        }
        if (each.endsWith(":")) {
            return new String[]{columns[0], ""};
        }
        Log.warning((String)("Skipping entry: " + each));
        return new String[]{"", ""};
    }

    protected String getStatisticsFromScript() {
        String output = "";
        File netStatisticsScript = new File("/sbin/net-statistics");
        try (PrintStream nullStream = new PrintStream("/dev/null");){
            BashScriptRunner scriptRunner = new BashScriptRunner(netStatisticsScript.getAbsolutePath() + " " + "eth0", nullStream);
            scriptRunner.execute();
            output = scriptRunner.getOutputString();
        }
        catch (IOException e) {
            Log.error((String)"Could not get network info", (Throwable)e);
        }
        if (output.isEmpty()) {
            Log.warning((String)"Could not understand the output from 'net-statistics' in '/sbin'");
        }
        return output;
    }
}

