/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.network.internal;

import com.ur.polyscope.system.impl.network.internal.NetworkStatistic;
import com.ur.polyscope.system.impl.network.internal.NetworkingService;
import java.util.HashMap;
import java.util.Map;

public class SimulatedNetworkingService
implements NetworkingService {
    private static final String NONE_IP = "0.0.0.0";
    private final Map<String, String> networkStatistics = new HashMap<String, String>();

    public SimulatedNetworkingService() {
        this.networkStatistics.put("Mode", "disabled");
        this.networkStatistics.put("Net", "Down");
        this.networkStatistics.put("Address", NONE_IP);
        this.networkStatistics.put("Mask", NONE_IP);
        this.networkStatistics.put("Gateway", NONE_IP);
        this.networkStatistics.put("nameserver1", NONE_IP);
        this.networkStatistics.put("nameserver2", NONE_IP);
        this.networkStatistics.put("Hostname", "localhost");
    }

    @Override
    public boolean isConnected(String address) {
        return "Up".equals(this.networkStatistics.get("Net"));
    }

    @Override
    public void startDHCP() {
        this.networkStatistics.put("Mode", "dhcp");
        this.networkStatistics.put("Address", "1.2.3.4");
        this.networkStatistics.put("Mask", "5.6.7.8");
        this.networkStatistics.put("Gateway", "1.2.3.0");
        this.networkStatistics.put("nameserver1", "1.1.1.1");
        this.networkStatistics.put("nameserver2", "1.0.0.1");
        this.networkStatistics.put("Net", "Up");
    }

    @Override
    public void setFixedIP(String ip, String subnet, String gateway, String dns1, String dns2) {
        this.networkStatistics.put("Mode", "static");
        this.networkStatistics.put("Address", ip);
        this.networkStatistics.put("Mask", subnet);
        this.networkStatistics.put("Gateway", gateway);
        this.networkStatistics.put("nameserver1", dns1);
        this.networkStatistics.put("nameserver2", dns2);
        this.networkStatistics.put("Net", "Up");
    }

    @Override
    public void disableNet() {
        this.networkStatistics.put("Mode", "disabled");
        this.networkStatistics.put("Net", "Down");
        this.networkStatistics.put("Address", NONE_IP);
        this.networkStatistics.put("Mask", NONE_IP);
        this.networkStatistics.put("Gateway", NONE_IP);
        this.networkStatistics.put("nameserver1", NONE_IP);
        this.networkStatistics.put("nameserver2", NONE_IP);
    }

    @Override
    public NetworkStatistic getNetworkStatistics() {
        return new NetworkStatistic(this.networkStatistics);
    }
}

