/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.screencalibration;

import com.ur.lang.IOUtil;
import com.ur.polyscope.system.impl.screencalibration.FileLocationProvider;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.inject.Inject;

public class TouchCalibrationConfig {
    public static final String TSCOM_CONFIG_FILE = "tscom-config";
    public static final String CALIBRATION_FILE = "touch_calibration.properties";
    public static final String MAX_X_KEY = "MaxX";
    public static final String MIN_X_KEY = "MinX";
    public static final String MID_X_KEY = "MidX";
    public static final String MAX_Y_KEY = "MaxY";
    public static final String MIN_Y_KEY = "MinY";
    public static final String MID_Y_KEY = "MidY";
    private int driverMaxX = 1023;
    private int driverMinX = 0;
    private int driverMidX = 512;
    private int driverMaxY = 1023;
    private int driverMinY = 0;
    private int driverMidY = 512;
    private Properties props;
    private FileLocationProvider fileProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    TouchCalibrationConfig(FileLocationProvider fileLocationProvider) {
        this.fileProvider = fileLocationProvider;
        this.props = new Properties();
        try {
            File theFile = this.fileProvider.getConfigFile(CALIBRATION_FILE);
            FileInputStream inStream = new FileInputStream(theFile);
            try {
                this.props.load(inStream);
            }
            finally {
                IOUtil.close((Closeable)inStream);
            }
        }
        catch (IOException e) {
            this.props.setProperty(MAX_Y_KEY, "969");
            this.props.setProperty(MAX_X_KEY, "961");
            this.props.setProperty(MIN_Y_KEY, "97");
            this.props.setProperty(MIN_X_KEY, "77");
            this.props.setProperty(MID_Y_KEY, "531");
            this.props.setProperty(MID_X_KEY, "519");
        }
    }

    public void save() {
        try {
            File theFile = this.fileProvider.getConfigFile(CALIBRATION_FILE);
            FileOutputStream out = new FileOutputStream(theFile);
            try {
                this.props.store(out, "");
            }
            finally {
                IOUtil.close((Closeable)out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeToTSCOMConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToTSCOMConfigFile() {
        block12: {
            BufferedReader in = null;
            BufferedWriter out = null;
            try {
                String line;
                File tscomFile = this.fileProvider.getTscomFile(TSCOM_CONFIG_FILE);
                in = new BufferedReader(new InputStreamReader(new FileInputStream(tscomFile)));
                String tscomString = "";
                while ((line = in.readLine()) != null) {
                    String key = line.split("=")[0];
                    if (key.matches("CalibrationX1")) {
                        tscomString = tscomString + "CalibrationX1=" + this.getMinX() + "\n";
                        continue;
                    }
                    if (key.matches("CalibrationX2")) {
                        tscomString = tscomString + "CalibrationX2=" + this.getMidX() + "\n";
                        continue;
                    }
                    if (key.matches("CalibrationX3")) {
                        tscomString = tscomString + "CalibrationX3=" + this.getMaxX() + "\n";
                        continue;
                    }
                    if (key.matches("CalibrationY1")) {
                        tscomString = tscomString + "CalibrationY1=" + this.getMinY() + "\n";
                        continue;
                    }
                    if (key.matches("CalibrationY2")) {
                        tscomString = tscomString + "CalibrationY2=" + this.getMidY() + "\n";
                        continue;
                    }
                    if (key.matches("CalibrationY3")) {
                        tscomString = tscomString + "CalibrationY3=" + this.getMaxY() + "\n";
                        continue;
                    }
                    tscomString = tscomString + line + "\n";
                }
                out = new BufferedWriter(new FileWriter(tscomFile));
                out.write(tscomString);
                IOUtil.close((Closeable)in);
            }
            catch (IOException e) {
                Log.warning((String)"Failed to replace file 'tscom-config'");
                break block12;
            }
            finally {
                IOUtil.close(in);
                IOUtil.close(out);
            }
            IOUtil.close((Closeable)out);
        }
    }

    public int getDriverMinX() {
        return this.driverMinX;
    }

    public int getDriverMaxX() {
        return this.driverMaxX;
    }

    public int getDriverMidX() {
        return this.driverMidX;
    }

    public int getDriverMinY() {
        return this.driverMinY;
    }

    public int getDriverMaxY() {
        return this.driverMaxY;
    }

    public int getDriverMidY() {
        return this.driverMidY;
    }

    public int getMinX() {
        return this.getValue(MIN_X_KEY, this.driverMinX);
    }

    public int getMaxX() {
        return this.getValue(MAX_X_KEY, this.driverMaxX);
    }

    public int getMidX() {
        return this.getValue(MID_X_KEY, this.driverMidX);
    }

    public int getMinY() {
        return this.getValue(MIN_Y_KEY, this.driverMinY);
    }

    public int getMaxY() {
        return this.getValue(MAX_Y_KEY, this.driverMaxY);
    }

    public int getMidY() {
        return this.getValue(MID_Y_KEY, this.driverMidY);
    }

    private int getValue(String key, int defaultValue) {
        if (this.props.containsKey(key)) {
            return Integer.parseInt(this.props.getProperty(key));
        }
        return defaultValue;
    }

    public void setMaxX(Integer val) {
        this.props.setProperty(MAX_X_KEY, val.toString());
    }

    public void setMinX(Integer val) {
        this.props.setProperty(MIN_X_KEY, val.toString());
    }

    public void setMidX(Integer val) {
        this.props.setProperty(MID_X_KEY, val.toString());
    }

    public void setMaxY(Integer val) {
        this.props.setProperty(MAX_Y_KEY, val.toString());
    }

    public void setMinY(Integer val) {
        this.props.setProperty(MIN_Y_KEY, val.toString());
    }

    public void setMidY(Integer val) {
        this.props.setProperty(MID_Y_KEY, val.toString());
    }

    public String toString() {
        return "TouchCalibrationConfig: Max(" + this.getMaxX() + ", " + this.getMaxY() + "); Mid(" + this.getMidX() + ", " + this.getMidY() + "); Min(" + this.getMinX() + ", " + this.getMinY() + ")";
    }
}

