/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.softwareupdate;

import com.google.common.io.CharStreams;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.system.impl.AbstractSystemPanel;
import com.ur.polyscope.system.impl.install.Installer;
import com.ur.polyscope.system.impl.install.InstallerBase;
import com.ur.polyscope.system.impl.install.InstallerListener;
import com.ur.polyscope.system.impl.install.webupdate.SoftwareUpdateDescriptionListSimple;
import com.ur.polyscope.system.impl.install.webupdate.SoftwareUpdateDescriptionSimple;
import com.ur.polyscope.system.impl.softwareupdate.SoftwareUpdateLayoutStrategy;
import com.ur.polyscope.system.impl.softwareupdate.UpdatePanel;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogCreator;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SoftwareUpdatePanel
extends AbstractSystemPanel
implements AdminLockListener {
    private static final String URUPDATE_SCRIPT = "urupdate";
    private final ControllerInterface controllerInterface;
    private final AdminLock adminLock;
    private DefaultListModel<SoftwareUpdateDescriptionSimple> mdlConfigs;
    private transient SoftwareUpdateDescriptionSimple currentConfig;
    private boolean installBtnEnable = false;
    JPanel updateListPanel;
    JPanel descriptionPanel;
    JPanel progressPanel;
    JButton btnUpdates;
    JList<SoftwareUpdateDescriptionSimple> lstUpdates;
    JScrollPane lstUpdatesScrPane;
    JTextArea descriptionArea;
    JScrollPane jsp;
    JProgressBar currentState;
    JButton btnInstall;
    private final MessageDialogCreator messageDialogCreator;
    private final ConfirmationDialogCreator confirmationDialogCreator;

    @Inject
    public SoftwareUpdatePanel(ControllerInterface controllerInterface, RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock) {
        super(passwordFooter, viewContext);
        this.controllerInterface = controllerInterface;
        this.messageDialogCreator = viewContext.getDialogCreator();
        this.confirmationDialogCreator = viewContext.getDialogCreator();
        this.adminLock = adminLock;
        this.initComponents();
        this.setActions();
        this.enableBtnInstall(false);
        if (FeatureToggle.isActive((String)"systemPassword")) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    private void setActions() {
        this.btnUpdates.addActionListener(e -> this.onUpdateConfigurations());
        this.btnInstall.addActionListener(e -> this.onInstallConfig());
        this.lstUpdates.addListSelectionListener(e -> this.setSelection(this.lstUpdates.getSelectedIndex()));
    }

    private void setSelection(int firstIndex) {
        if (firstIndex < 0 || firstIndex >= this.mdlConfigs.size()) {
            this.enableBtnInstall(false);
            this.descriptionArea.setText("");
        } else {
            SoftwareUpdateDescriptionSimple wc;
            this.currentConfig = wc = this.mdlConfigs.get(firstIndex);
            this.descriptionArea.setText(wc.getDescription());
            this.enableBtnInstall(true);
        }
    }

    private void enableBtnInstall(boolean enable) {
        this.installBtnEnable = enable;
        this.btnInstall.setEnabled(this.installBtnEnable);
    }

    private void onInstallConfig() {
        Installer currentInst = new Installer(this.currentConfig, this.textResource, this.messageDialogCreator);
        currentInst.addInstallerListener(new InstallerListener(){

            @Override
            public void onComplete(InstallerBase installer) {
                SoftwareUpdatePanel.this.currentState.setStringPainted(true);
                SoftwareUpdatePanel.this.currentState.setIndeterminate(false);
                SoftwareUpdatePanel.this.currentState.setStringPainted(false);
                SoftwareUpdatePanel.this.currentState.setValue(0);
                SoftwareUpdatePanel.this.currentState.setEnabled(false);
                SoftwareUpdatePanel.this.currentState.setVisible(false);
                SoftwareUpdatePanel.this.enableBtnInstall(true);
            }

            @Override
            public void onUpdate(int completeness, String stateString, InstallerBase installer) {
                SoftwareUpdatePanel.this.currentState.setStringPainted(true);
                SoftwareUpdatePanel.this.currentState.setIndeterminate(false);
                SoftwareUpdatePanel.this.currentState.setValue(completeness);
                SoftwareUpdatePanel.this.currentState.setString(stateString);
            }

            @Override
            public void onFailed(String path) {
                SoftwareUpdatePanel.this.messageDialogCreator.showMessageDialog(new DialogMessage(SoftwareUpdatePanel.this.textResource.Message(), SoftwareUpdatePanel.this.textResource.failedToUnpackUpdate(path)), MessageDialogType.MESSAGE, null);
                SwingUtil.invokeAndWait(() -> {
                    SoftwareUpdatePanel.this.currentState.setStringPainted(true);
                    SoftwareUpdatePanel.this.currentState.setIndeterminate(false);
                    SoftwareUpdatePanel.this.currentState.setStringPainted(false);
                    SoftwareUpdatePanel.this.currentState.setValue(0);
                    SoftwareUpdatePanel.this.currentState.setEnabled(false);
                    SoftwareUpdatePanel.this.enableBtnInstall(true);
                });
            }

            @Override
            public boolean requestReboot(InstallerBase installer) {
                return true;
            }

            @Override
            public boolean requestRestart(InstallerBase installer) {
                return true;
            }

            private ConfirmationMessage createConfirmUpdate() {
                return new ConfirmationMessage(SoftwareUpdatePanel.this.textResource.confirmUpdateTitle(), SoftwareUpdatePanel.this.textResource.confirmUpdateExplanationWithBackup(), SoftwareUpdatePanel.this.textResource.confirmUpdateAction(), SoftwareUpdatePanel.this.textResource.CANCEL());
            }

            private void handleCancel(InstallerBase installer) {
                installer.abortInstallation();
                SoftwareUpdatePanel.this.currentState.setIndeterminate(false);
                SoftwareUpdatePanel.this.currentState.setStringPainted(false);
                SoftwareUpdatePanel.this.currentState.setValue(0);
                SoftwareUpdatePanel.this.currentState.setEnabled(false);
                SoftwareUpdatePanel.this.enableBtnInstall(true);
            }

            private void handleProceed(InstallerBase installer) {
                SoftwareUpdatePanel.this.controllerInterface.runScript("power off");
                installer.start();
                SoftwareUpdatePanel.this.stackCurrentCardAndSwitchTo(UpdatePanel.class);
            }

            private void onCompleteShowConfirmationDialog(ConfirmationMessage confirmationMessage, final InstallerBase installer) {
                SoftwareUpdatePanel.this.confirmationDialogCreator.showConfirmationDialog(confirmationMessage, new ConfirmationDialogListener(){

                    public void onOkClicked() {
                        this.handleProceed(installer);
                    }

                    public void onCancelClicked() {
                        this.handleCancel(installer);
                    }
                });
            }

            @Override
            public void onDownloadComplete(InstallerBase installer) {
                this.onCompleteShowConfirmationDialog(this.createConfirmUpdate(), installer);
            }
        });
        this.enableBtnInstall(false);
        this.currentState.setEnabled(true);
        this.currentState.setVisible(true);
        this.currentState.setStringPainted(false);
        this.currentState.setIndeterminate(true);
        UpdatePanel panel = (UpdatePanel)this.getCardPanel(UpdatePanel.class);
        currentInst.addInstallerListener(panel);
        panel.setInstaller(currentInst);
        Thread thread = new Thread(currentInst::downloadData, "FirmwareUpdateThread");
        thread.start();
    }

    private void updateDescription(String text) {
        SwingUtil.invokeAndWait(() -> this.descriptionArea.setText(text));
    }

    private void clearSoftwareUpdateList() {
        SwingUtil.invokeAndWait(() -> this.mdlConfigs.clear());
    }

    private int updateSoftwareUpdateList(SoftwareUpdateDescriptionListSimple softwareUpdateList) {
        SwingUtil.invokeAndWait(() -> {
            if (!this.mdlConfigs.isEmpty()) {
                this.mdlConfigs.clear();
            }
            List<SoftwareUpdateDescriptionSimple> updateDescriptionList = softwareUpdateList.getFiles();
            updateDescriptionList.sort(Collections.reverseOrder());
            for (SoftwareUpdateDescriptionSimple conf : updateDescriptionList) {
                this.mdlConfigs.addElement(conf);
            }
        });
        return this.mdlConfigs.size();
    }

    private void setButtonEnabled(JButton button, boolean enabled) {
        SwingUtil.invokeAndWait(() -> button.setEnabled(enabled));
    }

    private void onUpdateConfigurations() {
        Runnable runner = () -> {
            SoftwareUpdateDescriptionListSimple softwareUpdateList = new SoftwareUpdateDescriptionListSimple();
            this.clearSoftwareUpdateList();
            try {
                Process p = new ProcessBuilder(URUPDATE_SCRIPT, "--list-updates").start();
                p.waitFor();
                InputStream inputStream = p.getInputStream();
                String s = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                List<SoftwareUpdateDescriptionSimple> potentialSoftwareUpdate = SoftwareUpdateDescriptionListSimple.buildFromScriptOutput(s);
                for (SoftwareUpdateDescriptionSimple softwareUpdateDescriptionSimple : potentialSoftwareUpdate) {
                    if (!this.checkVersion(softwareUpdateDescriptionSimple.getFilename())) continue;
                    softwareUpdateList.addSimpleConfiguration(softwareUpdateDescriptionSimple);
                }
            }
            catch (IOException ioException) {
                Log.error((String)"Interrupted in waiting for backup process to finish", (Throwable)ioException);
                this.setButtonEnabled(this.btnUpdates, true);
            }
            catch (InterruptedException interruptedException) {
                Log.error((String)"Interrupted in waiting for backup process to finish", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
            int configCount = this.updateSoftwareUpdateList(softwareUpdateList);
            this.setButtonEnabled(this.btnUpdates, true);
            if (configCount > 0) {
                this.updateDescription(" ");
            } else {
                this.updateDescription(this.textResource.noValidUpdatesFound());
            }
        };
        this.setButtonEnabled(this.btnUpdates, false);
        Thread thr = new Thread(runner, "FirmwareUpdatePanel_onUpdateConfigurations_Thread");
        thr.start();
    }

    private boolean checkVersion(String updateFile) throws IOException, InterruptedException {
        Process requiredVersionProcess = new ProcessBuilder(URUPDATE_SCRIPT, "--verify-requirements", updateFile).start();
        requiredVersionProcess.waitFor();
        return requiredVersionProcess.exitValue() == 0;
    }

    private void initComponents() {
        this.updateListPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.progressPanel = new JPanel();
        this.btnUpdates = new JButton(this.textResource.performSearch());
        this.mdlConfigs = new DefaultListModel();
        this.lstUpdates = new JList();
        this.lstUpdates.setSelectionMode(0);
        this.lstUpdates.setLayoutOrientation(0);
        this.lstUpdates.setVisibleRowCount(3);
        this.lstUpdates.setModel(this.mdlConfigs);
        this.lstUpdates.setBorder(null);
        this.lstUpdatesScrPane = new JScrollPane(this.lstUpdates);
        this.lstUpdatesScrPane.setBorder(null);
        new URFingerDragScrollMouseListener(this.lstUpdates);
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setText("");
        this.descriptionArea.setEditable(false);
        this.jsp = new JScrollPane(this.descriptionArea);
        new URFingerDragScrollMouseListener((Component)this.descriptionArea);
        this.descriptionPanel.setLayout(new BorderLayout());
        this.descriptionPanel.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.descriptionPanel.add(this.jsp);
        this.currentState = new JProgressBar();
        this.btnInstall = new JButton(this.textResource.performUpdate());
        SoftwareUpdateLayoutStrategy.applyLayoutTo(this, this.textResource);
        this.setLayout(new BorderLayout());
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        JPanel centerGroupPanel = new JPanel();
        centerGroupPanel.setLayout(new BoxLayout(centerGroupPanel, 3));
        centerGroupPanel.add(this.createCard(this.textResource.updateRobotSoftware(), this.updateListPanel));
        centerGroupPanel.add(this.createCard(this.textResource.Description(), this.descriptionPanel));
        centerGroupPanel.add(this.progressPanel);
        this.add(centerGroupPanel, "Center");
        this.addPasswordFooter();
        if (FeatureToggle.isActive((String)"systemPassword") && this.adminLock.isLocked()) {
            this.doLock();
        } else {
            this.doUnlock();
        }
    }

    public void doUnlock() {
        this.btnUpdates.setEnabled(true);
        this.btnInstall.setEnabled(this.installBtnEnable);
    }

    public void doLock() {
        this.btnUpdates.setEnabled(false);
        this.btnInstall.setEnabled(false);
    }
}

