/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.softwareupdate.commandline;

import com.ur.polyscope.system.impl.softwareupdate.commandline.TerminalBuffer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class JTerminalPane
extends JComponent {
    private Font theFont;
    private Color[] colors = new Color[]{Color.white, Color.black, Color.red, Color.green, Color.blue};
    TerminalBuffer buffer;
    private int fontW;
    private int fontH;
    private int fontA;

    public JTerminalPane() {
        this.buffer = new TerminalBuffer();
        this.initialize();
    }

    public JTerminalPane(char w, char h) {
        this.buffer = new TerminalBuffer(w, h);
        this.initialize();
    }

    private void initialize() {
        this.colors[0] = UIManager.getColor("window");
        this.theFont = new Font("DialogInput", 0, 12);
        FontMetrics met = this.getFontMetrics(this.theFont);
        this.fontW = met.charWidth('w');
        this.fontH = met.getHeight();
        this.fontA = met.getDescent();
        this.setPreferredSize(new Dimension(this.buffer.getColumns() * this.fontW, this.buffer.getLines() * this.fontH));
        this.buffer.clearScreen();
    }

    public void print(String str) {
        this.buffer.parseString(str);
        this.repaint();
    }

    public void println(String str) {
        this.buffer.parseString(str + "\n");
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setFont(this.theFont);
        this.paintTerminal(g);
        this.paintCursor(g);
    }

    private void paintCursor(Graphics g) {
        int x = this.buffer.getCursorColumn();
        int y = this.buffer.getCursorLine();
        g.setColor(this.colors[1]);
        g.drawRect(x * this.fontW, y * this.fontH, this.fontW, this.fontH);
    }

    private void paintTerminal(Graphics g) {
        for (int i = 0; i < this.buffer.getLines(); ++i) {
            for (int j = 0; j < this.buffer.getColumns(); ++j) {
                g.setColor(this.colors[this.buffer.backColor[i][j]]);
                g.fillRect(j * this.fontW, i * this.fontH, this.fontW, this.fontH);
                g.setColor(this.colors[this.buffer.foreColor[i][j]]);
                g.drawString("" + this.buffer.characters[i][j], j * this.fontW, (i + 1) * this.fontH - this.fontA);
            }
        }
    }

    public void clearScreen() {
        this.buffer.clearScreen();
    }
}

