/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.softwareupdate.commandline;

import java.util.StringTokenizer;

public class TerminalBuffer {
    private char LINES = (char)25;
    private char COLS = (char)60;
    private char savedLine = '\u0000';
    private char savedCol = '\u0000';
    public char[][] characters;
    public char[][] foreColor;
    public char[][] backColor;
    private char currentFore = '\u0001';
    private char currentBack = '\u0000';
    private char currentCol = '\u0000';
    private char currentLine = '\u0000';
    private boolean inCommand = false;
    private String currentCommand;

    public TerminalBuffer() {
        this.LINES = (char)25;
        this.COLS = (char)60;
        this.initialize();
    }

    public TerminalBuffer(char cols, char lines) {
        this.LINES = lines;
        this.COLS = cols;
        this.initialize();
    }

    private void initialize() {
        this.currentCol = '\u0000';
        this.currentLine = '\u0000';
        this.currentFore = '\u0001';
        this.currentBack = '\u0000';
        this.characters = new char[this.LINES][this.COLS];
        this.foreColor = new char[this.LINES][this.COLS];
        this.backColor = new char[this.LINES][this.COLS];
    }

    private void scrollBuffer() {
        int i;
        for (i = 0; i < this.LINES - '\u0001'; ++i) {
            this.characters[i] = this.characters[i + 1];
            this.foreColor[i] = this.foreColor[i + 1];
            this.backColor[i] = this.backColor[i + 1];
        }
        this.characters[this.LINES - '\u0001'] = new char[this.COLS];
        this.foreColor[this.LINES - '\u0001'] = new char[this.COLS];
        this.backColor[this.LINES - '\u0001'] = new char[this.COLS];
        for (i = 0; i < this.COLS; ++i) {
            this.characters[this.LINES - '\u0001'][i] = 32;
            this.foreColor[this.LINES - '\u0001'][i] = '\u0001';
            this.backColor[this.LINES - '\u0001'][i] = '\u0000';
        }
        this.currentLine = (char)(this.currentLine - '\u0001');
    }

    public void clearScreen() {
        for (int i = 0; i < this.LINES; ++i) {
            for (int j = 0; j < this.COLS; ++j) {
                this.characters[i][j] = 32;
                this.foreColor[i][j] = '\u0001';
                this.backColor[i][j] = '\u0000';
            }
            this.currentCol = '\u0000';
            this.currentLine = '\u0000';
        }
    }

    private void parseSpecialCommand(String cmd) {
        if (cmd.charAt(0) != '[' || cmd.contains(" !#\ufffd%&/()")) {
            this.inCommand = false;
            this.parseString(this.currentCommand);
            return;
        }
        if (cmd.length() < 2) {
            return;
        }
        this.inCommand = false;
        String mc = cmd.substring(1, cmd.length() - 1);
        switch (cmd.charAt(cmd.length() - 1)) {
            case 'm': {
                StringTokenizer st = new StringTokenizer(mc, ";");
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.length() == 2 && tok.charAt(0) != '0') {
                        if (tok.charAt(0) == '3') {
                            this.currentFore = tok.charAt(1);
                            this.currentFore = (char)(this.currentFore - 48);
                        }
                        if (tok.charAt(0) == '4') {
                            this.currentBack = tok.charAt(1);
                            this.currentBack = (char)(this.currentBack - 48);
                        }
                    }
                    if (tok.length() == 2 && tok.charAt(0) == '0') {
                        tok = tok.substring(1);
                    }
                    if (!tok.equals("0")) continue;
                    this.currentFore = '\u0001';
                    this.currentBack = '\u0000';
                }
                break;
            }
            case 'J': {
                this.clearScreen();
                break;
            }
            case 'A': {
                this.currentLine = (char)(this.currentLine - (char)Integer.parseInt(mc));
                break;
            }
            case 'B': {
                this.currentLine = (char)(this.currentLine + (char)Integer.parseInt(mc));
                break;
            }
            case 'C': {
                this.currentCol = (char)(this.currentCol - (char)Integer.parseInt(mc));
                break;
            }
            case 'D': {
                this.currentCol = (char)(this.currentCol + (char)Integer.parseInt(mc));
                break;
            }
            case 'R': {
                StringTokenizer st = new StringTokenizer(mc, ";");
                this.currentLine = (char)Integer.parseInt(st.nextToken());
                this.currentCol = (char)Integer.parseInt(st.nextToken());
                break;
            }
            case 's': {
                this.savedLine = this.currentLine;
                this.savedCol = this.currentCol;
                break;
            }
            case 'u': {
                this.currentLine = this.savedLine;
                this.currentCol = this.savedCol;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case ';': {
                this.inCommand = true;
            }
        }
        if (this.currentCol >= this.COLS) {
            this.currentCol = this.COLS;
            this.currentCol = (char)(this.currentCol - '\u0001');
        }
        if (this.currentCol < '\u0000') {
            this.currentCol = '\u0000';
        }
        if (this.currentLine >= this.LINES) {
            this.currentLine = this.LINES;
            this.currentLine = (char)(this.currentLine - '\u0001');
        }
        if (this.currentLine < '\u0000') {
            this.currentLine = '\u0000';
        }
    }

    private boolean parseCommand(char c) {
        if (this.inCommand) {
            this.currentCommand = this.currentCommand + c;
            this.parseSpecialCommand(this.currentCommand);
        } else {
            switch (c) {
                case '\u001b': {
                    this.inCommand = true;
                    this.currentCommand = "";
                    break;
                }
                case '\b': {
                    this.currentCol = (char)(this.currentCol - '\u0001');
                    break;
                }
                case '\n': {
                    this.currentLine = (char)(this.currentLine + '\u0001');
                }
                case '\r': {
                    this.currentCol = '\u0000';
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public void parseString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            this.parseChar(c);
        }
    }

    private void parseChar(char c) {
        if (!this.parseCommand(c)) {
            this.characters[this.currentLine][this.currentCol] = c;
            this.foreColor[this.currentLine][this.currentCol] = this.currentFore;
            this.backColor[this.currentLine][this.currentCol] = this.currentBack;
            this.currentCol = (char)(this.currentCol + '\u0001');
        }
        if (this.currentCol == this.COLS) {
            this.currentCol = '\u0000';
            this.currentLine = (char)(this.currentLine + '\u0001');
        }
        if (this.currentLine == this.LINES) {
            this.scrollBuffer();
        }
    }

    public int getCursorColumn() {
        return this.currentCol;
    }

    public int getCursorLine() {
        return this.currentLine;
    }

    public int getColumns() {
        return this.COLS;
    }

    public int getLines() {
        return this.LINES;
    }
}

