/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.time;

import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.time.SetTimePanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SetTimeLayoutStrategy
implements SetTimePanel.LayoutStrategy {
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    private final TextResource textResource;
    private final ViewContext viewContext;
    private final WidgetFactory widgetFactory;

    @Inject
    public SetTimeLayoutStrategy(TextResource textResource, ViewContext viewContext) {
        this.textResource = textResource;
        this.viewContext = viewContext;
        this.widgetFactory = viewContext.createWidgetFactory();
    }

    @Override
    public void applyLayoutTo(SetTimePanel panel) {
        JPanel timeSelectionPanel = this.viewContext.createFormBuilder().component((JComponent)this.widgetFactory.createLabel(this.textResource.selectCurrentTime()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)panel.hourPlus, new FormBuilder.PanelConstraints[0]).spacer().component((JComponent)panel.minutePlus, new FormBuilder.PanelConstraints[0]).spacer().component((JComponent)panel.secondPlus, new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.hourField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.widgetFactory.createLabel(":"), new FormBuilder.PanelConstraints[0]).component((JComponent)panel.minuteField, new FormBuilder.PanelConstraints[0]).component((JComponent)this.widgetFactory.createLabel(":"), new FormBuilder.PanelConstraints[0]).component((JComponent)panel.secondField, new FormBuilder.PanelConstraints[0]).component((JComponent)panel.ampmLabel, new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.hourMinus, new FormBuilder.PanelConstraints[0]).spacer().component((JComponent)panel.minuteMinus, new FormBuilder.PanelConstraints[0]).spacer().component((JComponent)panel.secondMinus, new FormBuilder.PanelConstraints[0]).end().groupColumns(new int[]{2, 4}).getPanel();
        JPanel timeFormatPanel = this.viewContext.createFormBuilder().component((JComponent)this.widgetFactory.createLabel(this.textResource.timeFormat()), new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.button12Hours, new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.button24Hours, new FormBuilder.PanelConstraints[0]).end().end().getPanel();
        JPanel datePickerPanel = new JPanel();
        datePickerPanel.setLayout(new BoxLayout(datePickerPanel, 3));
        panel.datePickerTextField.setPreferredSize(new Dimension(250, 30));
        panel.datePickerTextField.setMinimumSize(new Dimension(250, 30));
        panel.datePickerTextField.setAlignmentX(0.0f);
        panel.datePicker.setAlignmentX(0.0f);
        datePickerPanel.add(panel.datePickerTextField);
        datePickerPanel.add((Component)panel.datePicker);
        JPanel dateSelectionPanel = this.viewContext.createFormBuilder().component((JComponent)this.widgetFactory.createLabel(this.textResource.selectCurrentDate()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)datePickerPanel, new FormBuilder.PanelConstraints[0]).end().spacer().end().getPanel();
        JPanel dateFormatPanel = this.viewContext.createFormBuilder().component((JComponent)this.widgetFactory.createLabel(this.textResource.dateFormat()), new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.buttonLongDate, new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.buttonMediumDate, new FormBuilder.PanelConstraints[0]).end().component((JComponent)panel.buttonShortDate, new FormBuilder.PanelConstraints[0]).end().getPanel();
        JPanel timeCard = this.createCard(this.textResource.setTime(), timeSelectionPanel, timeFormatPanel);
        JPanel dateCard = this.createCard(this.textResource.setDate(), dateSelectionPanel, dateFormatPanel);
        JPanel restartPanel = panel.createRestartPanel(this.viewContext);
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setBackground(BETWEEN_CARD_COLOR);
        panel.setLayout(new BorderLayout(5, 5));
        panel.add(timeCard, "North");
        panel.add(dateCard, "Center");
        panel.add(restartPanel, "South");
    }

    private JPanel createCard(String title, JPanel mainSettings, JPanel remainingSettings) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.setBorder((Border)new CardBorder(title));
        result.add(this.wrapAsMainSettings(mainSettings));
        remainingSettings.setAlignmentY(0.0f);
        result.add(remainingSettings);
        return result;
    }

    private JPanel wrapAsMainSettings(JPanel settingsPanel) {
        JPanel result = new JPanel(new BorderLayout(0, 0));
        result.setPreferredSize(new Dimension(400, 200));
        result.setMaximumSize(new Dimension(400, 200));
        result.setAlignmentY(0.0f);
        result.add((Component)settingsPanel, "Center");
        return result;
    }
}

