/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl.time;

import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.system.impl.ApplyAndRestartPanel;
import com.ur.polyscope.system.impl.Settings;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.swing.HourFormat;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.plaf.basic.BasicDatePickerUI;

public class SetTimePanel
extends ApplyAndRestartPanel {
    private static final String BIN_BASH = "/bin/bash";
    private static final String COMMAND = "-c";
    private static final String SET_NTP_FALSE = "timedatectl set-ntp false";
    private static final String SET_DATE = "date --set=";
    private static final String SET_HWCLOCK = "hwclock -w";
    private Calendar timeOffset;
    private Calendar date;
    private Timer timer;
    private HourFormat newHourFormat;
    private Integer newDateFormatChoice;
    private final Locale locale;
    private final SimpleDateFormat ampmFormat;
    private final SimpleDateFormat h12Format;
    private final SimpleDateFormat h24Format;
    private final SimpleDateFormat minFormat;
    private final SimpleDateFormat secFormat;
    private SimpleDateFormat currentHourFormat;
    private TextResource textResource;
    private final URFontFactory fontFactory;
    public JLabel ampmLabel;
    public JRadioButton button12Hours;
    public JRadioButton button24Hours;
    public JRadioButton buttonLongDate;
    public JRadioButton buttonMediumDate;
    public JRadioButton buttonShortDate;
    public JXDatePicker datePicker;
    public JTextField datePickerTextField;
    public JTextField hourField;
    public AbstractButton hourMinus;
    public AbstractButton hourPlus;
    public JTextField minuteField;
    public AbstractButton minuteMinus;
    public AbstractButton minutePlus;
    public JTextField secondField;
    public AbstractButton secondMinus;
    public AbstractButton secondPlus;

    @Inject
    public SetTimePanel(TextResource textResource, URFontFactory fontFactory, LayoutStrategy layoutStrategy, ShutdownService shutdownService, EventManager eventManager) {
        super(shutdownService, eventManager);
        this.textResource = textResource;
        this.fontFactory = fontFactory;
        this.initComponents();
        this.restartNowButton.setEnabled(false);
        this.locale = Settings.getLanguage().getLocale();
        this.ampmFormat = new SimpleDateFormat("aa", this.locale);
        this.h12Format = new SimpleDateFormat(HourFormat.H12.getSimpleDisplayString());
        this.h24Format = new SimpleDateFormat(HourFormat.H24.getSimpleDisplayString());
        this.minFormat = new SimpleDateFormat("mm");
        this.secFormat = new SimpleDateFormat("ss");
        this.currentHourFormat = new SimpleDateFormat(Settings.getHourFormatChoice().getDisplayString());
        this.timeOffset = Calendar.getInstance();
        this.date = Calendar.getInstance();
        this.initialiseDatePicker();
        this.datePickerTextField.setEditable(false);
        this.datePickerTextField.setBackground(Color.WHITE);
        if (Settings.getLanguage() == LanguageConfiguration.SupportedLanguage.jp || Settings.getLanguage() == LanguageConfiguration.SupportedLanguage.zh) {
            this.buttonLongDate.setVisible(false);
            Settings.setDateFormatStyleChoice(2);
        }
        this.hourField.setEditable(false);
        this.hourField.setBackground(Color.WHITE);
        this.minuteField.setEditable(false);
        this.minuteField.setBackground(Color.WHITE);
        this.secondField.setEditable(false);
        this.secondField.setBackground(Color.WHITE);
        layoutStrategy.applyLayoutTo(this);
    }

    public void updateClock() {
        Date time = this.getAdjustedTime();
        this.hourField.setText("" + this.currentHourFormat.format(time.getTime()));
        this.minuteField.setText("" + this.minFormat.format(time.getTime()));
        this.secondField.setText("" + this.secFormat.format(time.getTime()));
        if (this.is12hClock()) {
            this.ampmLabel.setText(this.ampmFormat.format(time.getTime()));
        } else {
            this.ampmLabel.setText("");
        }
    }

    private boolean is12hClock() {
        return this.currentHourFormat != null && this.currentHourFormat == this.h12Format;
    }

    private Date getAdjustedTime() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(11, this.timeOffset.get(11));
        c.add(12, this.timeOffset.get(12));
        c.add(13, this.timeOffset.get(13));
        c.set(this.date.get(1), this.date.get(2), this.date.get(5));
        return c.getTime();
    }

    private void initialiseDatePicker() {
        this.datePicker.getMonthView().setFirstDayOfWeek(2);
        this.datePicker.setLocale(this.locale);
        this.datePicker.setLinkDay(new Date(), "");
        this.datePicker.setFormats(new DateFormat[]{Settings.getDateFormat()});
    }

    private void updateTimeFields() {
        this.currentHourFormat = this.newHourFormat != null ? (HourFormat.H12 == this.newHourFormat ? this.h12Format : this.h24Format) : (HourFormat.H12 == Settings.getHourFormatChoice() ? this.h12Format : this.h24Format);
    }

    private void setTime(Date time) {
        try {
            Process disableNTP = Runtime.getRuntime().exec(new String[]{BIN_BASH, COMMAND, SET_NTP_FALSE});
            disableNTP.waitFor();
            Runtime.getRuntime().exec(new String[]{BIN_BASH, COMMAND, "date --set=\"" + time + "\""});
            Runtime.getRuntime().exec(new String[]{BIN_BASH, COMMAND, SET_HWCLOCK});
        }
        catch (Exception e) {
            Log.error((String)"Could not set system time", (Throwable)e);
        }
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        this.restartNowButton.setEnabled(false);
        this.timeOffset.setTime(new Date());
        this.timeOffset.set(11, 0);
        this.timeOffset.set(12, 0);
        this.timeOffset.set(13, 0);
        this.date.setTime(new Date());
        this.updateCard();
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SetTimePanel.this.updateClock();
                    }
                });
            }
        }, 0L, 100L);
    }

    @Override
    public Object exit() {
        this.timer.cancel();
        return super.exit();
    }

    private void updateCard() {
        this.newHourFormat = null;
        this.newDateFormatChoice = null;
        if (Settings.getHourFormatChoice() == HourFormat.H12) {
            this.button12Hours.setSelected(true);
        } else {
            this.button24Hours.setSelected(true);
        }
        if (Settings.getDateFormatStyleChoice() == 3) {
            this.buttonShortDate.setSelected(true);
        } else if (Settings.getDateFormatStyleChoice() == 2) {
            this.buttonMediumDate.setSelected(true);
        } else {
            this.buttonLongDate.setSelected(true);
        }
        this.updateTimeFields();
        this.updateDatePickerTextField();
        this.updateDateFormatButtons();
    }

    private void updateDateFormatButtons() {
        this.buttonShortDate.setText(DateFormat.getDateInstance(3, Settings.getLanguage().getLocale()).format(this.date.getTime()));
        this.buttonMediumDate.setText(DateFormat.getDateInstance(2, Settings.getLanguage().getLocale()).format(this.date.getTime()));
        this.buttonLongDate.setText(DateFormat.getDateInstance(1, Settings.getLanguage().getLocale()).format(this.date.getTime()));
    }

    private void updateDatePickerTextField() {
        int i = this.newDateFormatChoice != null ? this.newDateFormatChoice : Settings.getDateFormatStyleChoice();
        DateFormat df = DateFormat.getDateInstance(i, this.locale);
        this.datePickerTextField.setText(df.format(this.date.getTime()));
    }

    protected void initComponents() {
        super.createApplyAndRestartButton(this.textResource);
        this.datePicker = new JXDatePicker(new Date());
        this.hourField = new JTextField();
        this.minuteField = new JTextField();
        this.secondField = new JTextField();
        this.button24Hours = new JRadioButton();
        this.button12Hours = new JRadioButton();
        this.buttonLongDate = new JRadioButton();
        this.buttonMediumDate = new JRadioButton();
        this.buttonShortDate = new JRadioButton();
        this.ampmLabel = new JLabel();
        this.datePickerTextField = new JTextField();
        ButtonGroup timeFormatBG = new ButtonGroup();
        timeFormatBG.add(this.button24Hours);
        timeFormatBG.add(this.button12Hours);
        ButtonGroup dateFormatBG = new ButtonGroup();
        dateFormatBG.add(this.buttonLongDate);
        dateFormatBG.add(this.buttonMediumDate);
        dateFormatBG.add(this.buttonShortDate);
        this.datePicker.setEnabled(false);
        this.datePicker.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.datePicker.setMaximumSize(new Dimension(0, 28));
        this.datePicker.setMinimumSize(new Dimension(0, 28));
        this.datePicker.setName("DatePickerDropDown");
        this.datePicker.setPreferredSize(new Dimension(0, 28));
        this.datePicker.addActionListener((ActionListener)new DatePickerListener());
        this.hourPlus = this.createIncreaseButton(new TimeOffsetListener(11, 1));
        this.hourMinus = this.createDecreaseButton(new TimeOffsetListener(11, -1));
        this.hourField.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        this.hourField.setHorizontalAlignment(0);
        this.hourField.setText("14");
        this.hourField.setPreferredSize(null);
        this.minutePlus = this.createIncreaseButton(new TimeOffsetListener(12, 1));
        this.minuteMinus = this.createDecreaseButton(new TimeOffsetListener(12, -1));
        this.minuteField.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        this.minuteField.setHorizontalAlignment(0);
        this.minuteField.setText("00");
        this.minuteField.setPreferredSize(null);
        this.secondField.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        this.secondField.setHorizontalAlignment(0);
        this.secondField.setText("00");
        this.secondField.setPreferredSize(null);
        this.secondPlus = this.createIncreaseButton(new TimeOffsetListener(13, 1));
        this.secondMinus = this.createDecreaseButton(new TimeOffsetListener(13, -1));
        this.button24Hours.setText(this.textResource._24hour());
        this.button24Hours.setMaximumSize(new Dimension(180, 22));
        this.button24Hours.setPreferredSize(new Dimension(120, 22));
        this.button24Hours.addActionListener(new HourFormatListener(HourFormat.H24));
        this.button12Hours.setText(this.textResource._12hour());
        this.button12Hours.setMaximumSize(new Dimension(180, 22));
        this.button12Hours.setPreferredSize(new Dimension(120, 22));
        this.button12Hours.addActionListener(new HourFormatListener(HourFormat.H12));
        this.buttonLongDate.setText("28 December 2012");
        this.buttonLongDate.addActionListener(new DateFormatListener(1));
        this.buttonMediumDate.setText("28 Dec 2012");
        this.buttonMediumDate.addActionListener(new DateFormatListener(2));
        this.buttonShortDate.setText("28/12/2012");
        this.buttonShortDate.addActionListener(new DateFormatListener(3));
        this.ampmLabel.setText("PM");
        this.ampmLabel.setPreferredSize(new Dimension(40, 40));
        this.datePickerTextField.setHorizontalAlignment(0);
        this.datePickerTextField.setText("28 December 2012");
        this.datePickerTextField.setPreferredSize(new Dimension(137, 28));
        this.datePickerTextField.addMouseListener(new DatePickerFieldListener());
    }

    private AbstractButton createIncreaseButton(MouseListener listener) {
        return this.createButton("+", listener);
    }

    private AbstractButton createDecreaseButton(MouseListener listener) {
        return this.createButton("-", listener);
    }

    private AbstractButton createButton(String text, MouseListener listener) {
        JButton result = new JButton();
        result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.VERY_LARGE));
        result.setText(text);
        result.setPreferredSize(null);
        result.addMouseListener(listener);
        return result;
    }

    private void updateRestartButton() {
        this.restartNowButton.setEnabled(this.isRestartRequired());
    }

    @Override
    protected void applySettingsPerformed() {
        if (this.newHourFormat != null && Settings.getHourFormatChoice() != this.newHourFormat) {
            Settings.setHourFormat(this.newHourFormat);
        }
        if (this.newDateFormatChoice != null && Settings.getDateFormatStyleChoice() != this.newDateFormatChoice) {
            Settings.setDateFormatStyleChoice(this.newDateFormatChoice);
        }
        if (this.isTimeAdjusted() || this.isDateAdjusted()) {
            this.setTime(this.getAdjustedTime());
        }
        Settings.saveSettings();
    }

    private boolean isRestartRequired() {
        return this.newHourFormat != null && Settings.getHourFormatChoice() != this.newHourFormat || this.newDateFormatChoice != null && Settings.getDateFormatStyleChoice() != this.newDateFormatChoice || this.isTimeAdjusted() || this.isDateAdjusted();
    }

    private boolean isTimeAdjusted() {
        return this.timeOffset.get(11) != 0 || this.timeOffset.get(12) != 0 || this.timeOffset.get(13) != 0;
    }

    private boolean isDateAdjusted() {
        Calendar now = Calendar.getInstance();
        now.setTime(new Date());
        return this.date.get(1) != now.get(1) || this.date.get(2) != now.get(2) || this.date.get(5) != now.get(5);
    }

    private class DatePickerFieldListener
    extends MouseAdapter {
        private DatePickerFieldListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            ((BasicDatePickerUI)SetTimePanel.this.datePicker.getUI()).toggleShowPopup();
        }
    }

    private class DatePickerListener
    implements ActionListener {
        private DatePickerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SetTimePanel.this.date.setTime(SetTimePanel.this.datePicker.getDate());
            SetTimePanel.this.updateDateFormatButtons();
            SetTimePanel.this.updateDatePickerTextField();
            SetTimePanel.this.updateRestartButton();
        }
    }

    private class DateFormatListener
    implements ActionListener {
        private final int dateFormat;

        public DateFormatListener(int dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SetTimePanel.this.newDateFormatChoice = this.dateFormat;
            SetTimePanel.this.updateDatePickerTextField();
            SetTimePanel.this.updateRestartButton();
        }
    }

    private class HourFormatListener
    implements ActionListener {
        private final HourFormat hourFormat;

        public HourFormatListener(HourFormat hourFormat) {
            this.hourFormat = hourFormat;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SetTimePanel.this.newHourFormat = this.hourFormat;
            SetTimePanel.this.updateTimeFields();
            SetTimePanel.this.updateRestartButton();
        }
    }

    private class TimeOffsetListener
    extends MouseAdapter {
        static final int LONG_PRESS_DELAY = 400;
        static final int REPEAT_RATE = 100;
        private final int field;
        private final int amount;
        private Timer longPress;

        public TimeOffsetListener(int field, int amount) {
            this.field = field;
            this.amount = amount;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.update();
            this.longPress = new Timer();
            this.longPress.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    SwingUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TimeOffsetListener.this.update();
                        }
                    });
                }
            }, 400L, 100L);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.longPress.cancel();
        }

        private void update() {
            SetTimePanel.this.timeOffset.add(this.field, this.amount);
            SetTimePanel.this.updateClock();
            SetTimePanel.this.updateRestartButton();
        }
    }

    public static interface LayoutStrategy {
        public void applyLayoutTo(SetTimePanel var1);
    }
}

