/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility.impl;

import com.ur.polyscope.urcaps.contributions.compatibility.Version;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.PomXMLAPIVersionParser;
import com.ur.urcap.api.domain.robot.RobotModel;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;

public final class BundleInfo {
    public static final String URCAP_COMPATIBILITY_CB_3 = "URCapCompatibility-CB3";
    public static final String URCAP_COMPATIBILITY_E_SERIES = "URCapCompatibility-eSeries";
    public static final String URCAP_PACKAGE_IMPORTS = "Import-Package";
    public static final String BUNDLE_NAME = "Bundle-Name";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private final String bundleName;
    private final Version apiVersion;
    private final Dictionary<String, String> headers;
    private final EnumMap<RobotModel.RobotSeries, Compatible> robotSeriesCompatibilityMap;

    private BundleInfo(String bundleName, Dictionary<String, String> manifestHeaders, Version apiVersion) {
        this.bundleName = bundleName;
        this.headers = manifestHeaders;
        this.apiVersion = apiVersion;
        this.robotSeriesCompatibilityMap = new EnumMap(RobotModel.RobotSeries.class);
    }

    public static BundleInfo create(File file) {
        Dictionary<String, String> headers = BundleInfo.properties2Dictionary(BundleInfo.getManifestProperties(file));
        String bundleName = headers.get(BUNDLE_NAME);
        Version apiVersion = BundleInfo.getVersionFromPomXML(file);
        BundleInfo manifest = new BundleInfo(bundleName, headers, apiVersion);
        BundleInfo.parseManifest(headers, manifest);
        return manifest;
    }

    public static BundleInfo create(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String bundleName = (String)headers.get(BUNDLE_NAME);
        Version apiVersion = BundleInfo.getVersionFromPomXML(bundle);
        BundleInfo manifest = new BundleInfo(bundleName, headers, apiVersion);
        BundleInfo.parseManifest(headers, manifest);
        return manifest;
    }

    public String getPackageImports() {
        return this.headers.get(URCAP_PACKAGE_IMPORTS);
    }

    public Version getApiVersion() {
        return this.apiVersion;
    }

    private static void parseManifest(Dictionary<String, String> headers, BundleInfo manifest) {
        Compatible cb3 = BundleInfo.parseCompatibility(headers, URCAP_COMPATIBILITY_CB_3);
        manifest.robotSeriesCompatibilityMap.put(RobotModel.RobotSeries.CB3, cb3);
        Compatible eSeries = BundleInfo.parseCompatibility(headers, URCAP_COMPATIBILITY_E_SERIES);
        manifest.robotSeriesCompatibilityMap.put(RobotModel.RobotSeries.E_SERIES, eSeries);
    }

    /*
     * Loose catch block
     */
    private static Properties getManifestProperties(File file) {
        Properties properties;
        ZipFile zf;
        block11: {
            zf = null;
            zf = new ZipFile(file);
            ZipEntry e = zf.getEntry("META-INF/MANIFEST.MF");
            Properties p = new Properties();
            p.load(zf.getInputStream(e));
            properties = p;
            if (zf == null) break block11;
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
        catch (Exception exception) {
            block12: {
                try {
                    if (zf == null) break block12;
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    private static Dictionary<String, String> properties2Dictionary(Properties properties) {
        if (properties == null) {
            return new Hashtable<String, String>();
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ((Dictionary)result).put(key, properties.getProperty(key));
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private static Version getVersionFromPomXML(File file) {
        Version version;
        ZipFile zf;
        block17: {
            ZipEntry pom;
            block15: {
                Version version2;
                block16: {
                    zf = null;
                    zf = new ZipFile(file);
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    pom = null;
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        if (!zipEntry.getName().startsWith("META-INF/maven/") || !zipEntry.getName().endsWith("pom.xml")) continue;
                        pom = zipEntry;
                        break;
                    }
                    if (pom != null) break block15;
                    version2 = new Version(null);
                    if (zf == null) break block16;
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {}
                }
                return version2;
            }
            InputStream is = zf.getInputStream(pom);
            PomXMLAPIVersionParser extractor = new PomXMLAPIVersionParser();
            version = extractor.parse(is);
            if (zf == null) break block17;
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return version;
        catch (Exception exception) {
            block18: {
                try {
                    if (zf == null) break block18;
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Version getVersionFromPomXML(Bundle bundle) {
        Enumeration poms;
        InputStream is;
        block13: {
            is = null;
            poms = bundle.findEntries("/META-INF/maven/", "pom.xml", true);
            if (poms.hasMoreElements()) break block13;
            if (is == null) return null;
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        URL url = (URL)poms.nextElement();
        is = url.openConnection().getInputStream();
        PomXMLAPIVersionParser extractor = new PomXMLAPIVersionParser();
        Version version = extractor.parse(is);
        if (is == null) return version;
        try {
            is.close();
            return version;
        }
        catch (IOException iOException) {}
        return version;
        catch (Exception e) {
            try {
                Log.warning((String)("Can't parse pom.xml from " + bundle.getSymbolicName() + " :" + e.getMessage()));
                if (is == null) return null;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Compatible getCompatibility(RobotModel.RobotSeries series) {
        Compatible compatible = this.robotSeriesCompatibilityMap.get(series);
        if (compatible == null) {
            return Compatible.UNDEFINED;
        }
        return compatible;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CompatibilityInfo{");
        sb.append("bundleName='").append(this.bundleName).append('\'');
        for (Map.Entry<RobotModel.RobotSeries, Compatible> entry : this.robotSeriesCompatibilityMap.entrySet()) {
            sb.append(",").append(entry.getKey()).append("=").append((Object)entry.getValue());
        }
        sb.append(", ApiVersion=").append(this.headers);
        sb.append('}');
        return sb.toString();
    }

    private static Compatible parseCompatibility(Dictionary<String, String> headers, String attribute) {
        String compatibility = headers.get(attribute);
        if (compatibility == null || !BundleInfo.validateAttributeNameinManifestWithCase(headers, attribute)) {
            return null;
        }
        if (TRUE.equals(compatibility)) {
            return Compatible.COMPATIBLE;
        }
        if (FALSE.equals(compatibility)) {
            return Compatible.NON_COMPATIBLE;
        }
        return Compatible.INVALID;
    }

    private static boolean validateAttributeNameinManifestWithCase(Dictionary<String, String> headers, String attribute) {
        Enumeration<String> keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.equals(attribute)) continue;
            return true;
        }
        return false;
    }

    static enum Compatible {
        UNDEFINED,
        COMPATIBLE,
        NON_COMPATIBLE,
        INVALID;

    }
}

