/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility.impl;

import com.ur.polyscope.urcaps.contributions.compatibility.Version;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PomXMLAPIVersionParser {
    public static final String DEPENDENCIES_TAG = "dependencies";
    public static final String DEPENDENCY_TAG = "dependency";
    public static final String GROUP_ID_TAG = "groupId";
    public static final String ARTIFACT_ID_TAG = "artifactId";
    public static final String VERSION_TAG = "version";

    public Version parse(InputStream is) throws VersionException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            VersionHandler handler = new VersionHandler();
            parser.parse(is, (DefaultHandler)handler);
            String versionString = handler.getVersion();
            if (versionString != null) {
                return new Version(versionString);
            }
        }
        catch (Exception e) {
            throw new VersionException(" Can't extract URCap api version", e);
        }
        return null;
    }

    static class VersionException
    extends Exception {
        public VersionException(String message, Exception cause) {
            super(message, cause);
        }
    }

    static class VersionHandler
    extends DefaultHandler {
        private boolean dependenciesTag;
        private boolean dependencyTag;
        private boolean groupIdTag;
        private boolean artifactIdTag;
        private boolean versionTag;
        private String lastGroupId = "";
        private String lastArtifactId = "";
        private String version = "";

        VersionHandler() {
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (PomXMLAPIVersionParser.DEPENDENCIES_TAG.equals(qName)) {
                this.dependenciesTag = true;
            } else if (PomXMLAPIVersionParser.DEPENDENCY_TAG.equals(qName)) {
                this.dependencyTag = true;
            } else if (PomXMLAPIVersionParser.GROUP_ID_TAG.equals(qName)) {
                this.groupIdTag = true;
                this.lastGroupId = "";
            } else if (PomXMLAPIVersionParser.ARTIFACT_ID_TAG.equals(qName)) {
                this.artifactIdTag = true;
                this.lastArtifactId = "";
            } else if (PomXMLAPIVersionParser.VERSION_TAG.equals(qName)) {
                this.versionTag = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String str = new String(ch, start, length);
            if (this.groupIdTag) {
                this.lastGroupId = String.valueOf(this.lastGroupId) + str;
            } else if (this.artifactIdTag) {
                this.lastArtifactId = String.valueOf(this.lastArtifactId) + str;
            } else if (this.versionTag && this.isURCapApiTag()) {
                this.version = String.valueOf(this.version) + str;
            }
        }

        private boolean isURCapApiTag() {
            return this.dependenciesTag && this.dependencyTag && "com.ur.urcap".equals(this.lastGroupId) && "api".equals(this.lastArtifactId);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (PomXMLAPIVersionParser.DEPENDENCIES_TAG.equals(qName)) {
                this.dependenciesTag = false;
            } else if (PomXMLAPIVersionParser.DEPENDENCY_TAG.equals(qName)) {
                this.dependencyTag = false;
            } else if (PomXMLAPIVersionParser.GROUP_ID_TAG.equals(qName)) {
                this.groupIdTag = false;
            } else if (PomXMLAPIVersionParser.ARTIFACT_ID_TAG.equals(qName)) {
                this.artifactIdTag = false;
            } else if (PomXMLAPIVersionParser.VERSION_TAG.equals(qName)) {
                this.versionTag = false;
            }
        }
    }
}

