/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility.impl;

import com.ur.polyscope.urcaps.contributions.compatibility.BundleCompatibilityValidator;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityValidationResult;
import com.ur.polyscope.urcaps.contributions.compatibility.Version;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.BundleInfo;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.BundleValidationResultImpl;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.ErrorBuilder;
import com.ur.polyscope.urcaps.version.URCapAPIPackageRepository;
import com.ur.urcap.api.domain.robot.RobotModel;
import com.ur.util.logging.Log;
import java.io.File;
import javax.inject.Inject;
import org.osgi.framework.Bundle;

public class URCapBundleCompatibilityValidatorImpl
implements BundleCompatibilityValidator {
    private static final Version COMPATIBILITY_REQUIRED_SINCE_VERSION = new Version(1, 11, 0);
    private final ErrorBuilder errorBuilder;
    private final URCapAPIPackageRepository urcapApiPackageRepository;

    @Inject
    public URCapBundleCompatibilityValidatorImpl(ErrorBuilder errorBuilder, URCapAPIPackageRepository apiPackageRepository) {
        this.errorBuilder = errorBuilder;
        this.urcapApiPackageRepository = apiPackageRepository;
    }

    public CompatibilityValidationResult validate(File file) {
        return this.validateManifest(BundleInfo.create(file), true);
    }

    public CompatibilityValidationResult validate(Bundle bundle) {
        return this.validateManifest(BundleInfo.create(bundle), false);
    }

    public CompatibilityValidationResult validateCompatibilityFlags(Bundle bundle) {
        return this.validateManifestForCompatibilityFlags(BundleInfo.create(bundle));
    }

    public CompatibilityValidationResult validateCompatibilityFlags(File file) {
        return this.validateManifestForCompatibilityFlags(BundleInfo.create(file));
    }

    public CompatibilityValidationResult validateAPIRequirements(File file) {
        BundleInfo manifest = BundleInfo.create(file);
        BundleValidationResultImpl result = new BundleValidationResultImpl();
        result.setCompatible(true);
        Version apiVersionRequiredByBundle = this.getBundleAPIVersion(manifest);
        if (apiVersionRequiredByBundle != null) {
            this.checkVersionCompatibility(manifest.getBundleName(), apiVersionRequiredByBundle, result);
        }
        return result;
    }

    private CompatibilityValidationResult validateManifest(BundleInfo manifest, boolean checkForVersionCompatibility) {
        RobotModel.RobotSeries robotSeries = this.getRobotSeries();
        BundleValidationResultImpl result = new BundleValidationResultImpl();
        result.setCompatible(true);
        Version apiVersionRequiredByBundle = this.getBundleAPIVersion(manifest);
        if (apiVersionRequiredByBundle != null) {
            if (checkForVersionCompatibility) {
                this.checkVersionCompatibility(manifest.getBundleName(), apiVersionRequiredByBundle, result);
            }
            if (result.isCompatible() && (URCapBundleCompatibilityValidatorImpl.isVersionRequireCompatibility(apiVersionRequiredByBundle) || URCapBundleCompatibilityValidatorImpl.hasAnyAttributeInManifest(manifest))) {
                this.checkManifestCompatibility(manifest, robotSeries, result);
            }
        } else if (URCapBundleCompatibilityValidatorImpl.hasAnyAttributeInManifest(manifest)) {
            this.checkManifestCompatibility(manifest, robotSeries, result);
        }
        return result;
    }

    private CompatibilityValidationResult validateManifestForCompatibilityFlags(BundleInfo manifest) {
        RobotModel.RobotSeries robotSeries = this.getRobotSeries();
        BundleValidationResultImpl result = new BundleValidationResultImpl();
        result.setCompatible(true);
        Version apiVersionRequiredByBundle = this.getBundleAPIVersion(manifest);
        if (URCapBundleCompatibilityValidatorImpl.isVersionRequireCompatibility(apiVersionRequiredByBundle) || URCapBundleCompatibilityValidatorImpl.hasAnyAttributeInManifest(manifest)) {
            this.checkManifestCompatibility(manifest, robotSeries, result);
        }
        return result;
    }

    private Version getBundleAPIVersion(BundleInfo manifest) {
        Version theirVersion = manifest.getApiVersion();
        if (theirVersion == null || new Version(null).equals((Object)theirVersion)) {
            theirVersion = this.tryToGetAPIVersionFromRepo(manifest);
        }
        return theirVersion;
    }

    private boolean checkVersionCompatibility(String bundleName, Version bundleAPIVersion, BundleValidationResultImpl result) {
        if (bundleAPIVersion == null) {
            return true;
        }
        String highestAPIVersionAvailableText = this.urcapApiPackageRepository.getlatestAPIVersionAvailable();
        if (highestAPIVersionAvailableText == null || highestAPIVersionAvailableText.isEmpty()) {
            Log.warning((String)"Cannot obtain available API Version");
            return true;
        }
        Version highestAPIVersionAvailable = new Version(highestAPIVersionAvailableText);
        if (bundleAPIVersion.isGreaterThen(highestAPIVersionAvailable)) {
            result.setCompatible(false);
            result.setError(this.errorBuilder.notCompatibleWithAPIVersion(bundleName));
            return false;
        }
        return true;
    }

    private Version tryToGetAPIVersionFromRepo(BundleInfo manifest) {
        Version theirVersion = null;
        URCapAPIPackageRepository.VersionInfo theirVersionInfo = this.urcapApiPackageRepository.getAPIVersionForPackageString(manifest.getPackageImports());
        if (theirVersionInfo.isVersionAvailable()) {
            theirVersion = new Version(theirVersionInfo.getVersion());
        }
        return theirVersion;
    }

    private void checkManifestCompatibility(BundleInfo manifest, RobotModel.RobotSeries robotSeries, BundleValidationResultImpl result) {
        String bundleName = manifest.getBundleName();
        BundleInfo.Compatible cb3Compatibility = manifest.getCompatibility(RobotModel.RobotSeries.CB3);
        BundleInfo.Compatible eSeriesCompatibility = manifest.getCompatibility(RobotModel.RobotSeries.E_SERIES);
        if (cb3Compatibility == BundleInfo.Compatible.UNDEFINED || eSeriesCompatibility == BundleInfo.Compatible.UNDEFINED) {
            result.setCompatible(false);
            this.setCompatibleFlagUndefinedError(cb3Compatibility, eSeriesCompatibility, result, bundleName);
        } else if (cb3Compatibility == BundleInfo.Compatible.INVALID || eSeriesCompatibility == BundleInfo.Compatible.INVALID) {
            result.setCompatible(false);
            this.setCompatibleFlagInvalidError(cb3Compatibility, eSeriesCompatibility, result, bundleName);
        } else if (manifest.getCompatibility(robotSeries) == BundleInfo.Compatible.NON_COMPATIBLE) {
            this.onUndefinedCompatibilityFlag(result, manifest, bundleName);
        }
    }

    private void setCompatibleFlagUndefinedError(BundleInfo.Compatible cb3Compatibility, BundleInfo.Compatible eSeriesCompatibility, BundleValidationResultImpl result, String bundleName) {
        if (cb3Compatibility == BundleInfo.Compatible.UNDEFINED && eSeriesCompatibility == BundleInfo.Compatible.UNDEFINED) {
            result.setError(this.errorBuilder.missingAllCompatibilityFlags(bundleName));
        } else if (cb3Compatibility == BundleInfo.Compatible.UNDEFINED) {
            result.setError(this.errorBuilder.missingCompatibilityFlag(bundleName, "URCapCompatibility-CB3"));
        } else {
            result.setError(this.errorBuilder.missingCompatibilityFlag(bundleName, "URCapCompatibility-eSeries"));
        }
    }

    private void setCompatibleFlagInvalidError(BundleInfo.Compatible cb3Compatibility, BundleInfo.Compatible eSeriesCompatibility, BundleValidationResultImpl result, String bundleName) {
        if (cb3Compatibility == BundleInfo.Compatible.INVALID && eSeriesCompatibility == BundleInfo.Compatible.INVALID) {
            result.setError(this.errorBuilder.invalidAllCompatibilityFlags(bundleName));
        } else if (cb3Compatibility == BundleInfo.Compatible.INVALID) {
            result.setError(this.errorBuilder.invalidCompatibilityFlag(bundleName, "URCapCompatibility-CB3"));
        } else {
            result.setError(this.errorBuilder.invalidCompatibilityFlag(bundleName, "URCapCompatibility-eSeries"));
        }
    }

    private RobotModel.RobotSeries getRobotSeries() {
        return RobotModel.RobotSeries.E_SERIES;
    }

    private static boolean hasAnyAttributeInManifest(BundleInfo manifest) {
        BundleInfo.Compatible cb3Compatibility = manifest.getCompatibility(RobotModel.RobotSeries.CB3);
        BundleInfo.Compatible eSeriesCompatibility = manifest.getCompatibility(RobotModel.RobotSeries.E_SERIES);
        return cb3Compatibility != BundleInfo.Compatible.UNDEFINED || eSeriesCompatibility != BundleInfo.Compatible.UNDEFINED;
    }

    private void onUndefinedCompatibilityFlag(BundleValidationResultImpl result, BundleInfo manifest, String bundleName) {
        BundleInfo.Compatible cb3Compatibility = manifest.getCompatibility(RobotModel.RobotSeries.CB3);
        BundleInfo.Compatible eSeriesCompatibility = manifest.getCompatibility(RobotModel.RobotSeries.E_SERIES);
        if (cb3Compatibility == BundleInfo.Compatible.NON_COMPATIBLE && eSeriesCompatibility == BundleInfo.Compatible.NON_COMPATIBLE) {
            result.setCompatible(false);
            result.setError(this.errorBuilder.notCompatibleWithAllRobots(bundleName));
        } else if (cb3Compatibility == BundleInfo.Compatible.COMPATIBLE) {
            result.setCompatible(false);
            result.setError(this.errorBuilder.notCompatibleWithThisRobot(bundleName, RobotModel.RobotSeries.CB3));
        } else if (eSeriesCompatibility == BundleInfo.Compatible.COMPATIBLE) {
            result.setCompatible(false);
            result.setError(this.errorBuilder.notCompatibleWithThisRobot(bundleName, RobotModel.RobotSeries.E_SERIES));
        } else {
            Log.warning((String)("Unsupported robot type compatibility found. Please add support to " + URCapBundleCompatibilityValidatorImpl.class.getName()));
        }
    }

    private static boolean isVersionRequireCompatibility(Version version) {
        return version != null && version.isGreaterThen(COMPATIBILITY_REQUIRED_SINCE_VERSION);
    }
}

