/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility.impl.errors;

import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.InvalidFlagError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.InvalidMultipleFlagsError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.MissingFlagError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.MissingMultipleFlagsError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.NewerURCapAPIVersionRequiredError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.NotCompatibleWithAllRobotsError;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.NotCompatibleWithThisRobotError;
import com.ur.urcap.api.domain.robot.RobotModel;
import javax.inject.Inject;

public class ErrorBuilder {
    private final TextResource textResource;

    @Inject
    public ErrorBuilder(TextResource textResource) {
        this.textResource = textResource;
    }

    public CompatibilityError missingCompatibilityFlag(String bundleName, String flagName) {
        return new MissingFlagError(this.textResource, bundleName, flagName);
    }

    public CompatibilityError missingAllCompatibilityFlags(String bundleName) {
        return new MissingMultipleFlagsError(this.textResource, bundleName);
    }

    public CompatibilityError notCompatibleWithAllRobots(String bundleName) {
        return new NotCompatibleWithAllRobotsError(this.textResource, bundleName);
    }

    public CompatibilityError notCompatibleWithThisRobot(String bundleName, RobotModel.RobotSeries robotSeries) {
        return new NotCompatibleWithThisRobotError(this.textResource, bundleName, robotSeries);
    }

    public CompatibilityError notCompatibleWithAPIVersion(String bundleName) {
        return new NewerURCapAPIVersionRequiredError(this.textResource, bundleName);
    }

    public CompatibilityError invalidCompatibilityFlag(String bundleName, String flagName) {
        return new InvalidFlagError(this.textResource, bundleName, flagName);
    }

    public CompatibilityError invalidAllCompatibilityFlags(String bundleName) {
        return new InvalidMultipleFlagsError(this.textResource, bundleName);
    }
}

