/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility.impl.errors;

import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.BaseValidationError;

public class InvalidFlagError
extends BaseValidationError {
    private final String flagName;

    protected InvalidFlagError(TextResource textResource, String bundleName, String flagName) {
        super(textResource, bundleName);
        this.flagName = flagName;
    }

    public String getMessage() {
        return String.format("This URCap has an invalid value specified for the required compatibility flag '%s' in the pom.xml file. Valid values are 'true' or 'false'.", this.flagName);
    }

    public String getLocalizedMessage() {
        return this.textResource.URCapInvalidCompatibilityFlag(this.flagName, "true", "false");
    }
}

