/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.contributions.compatibility.impl.errors;

import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.contributions.compatibility.impl.errors.BaseValidationError;
import com.ur.urcap.api.domain.robot.RobotModel;
import com.ur.util.logging.Log;

public class NotCompatibleWithThisRobotError
extends BaseValidationError {
    private final RobotModel.RobotSeries robotSeries;

    public NotCompatibleWithThisRobotError(TextResource textResource, String bundleName, RobotModel.RobotSeries robotSeries) {
        super(textResource, bundleName);
        this.robotSeries = robotSeries;
    }

    public String getMessage() {
        String errorMessage = "This URCap is not compatible with this robot series. ";
        switch (this.robotSeries) {
            case CB3: {
                errorMessage = String.valueOf(errorMessage) + "It requires a CB3 robot.";
                break;
            }
            case E_SERIES: {
                errorMessage = String.valueOf(errorMessage) + "It requires an e-Series robot.";
                break;
            }
            default: {
                errorMessage = "";
            }
        }
        return errorMessage;
    }

    public String getLocalizedMessage() {
        switch (this.robotSeries) {
            case E_SERIES: {
                return this.textResource.URCapRequiresESeries();
            }
            case CB3: {
                return this.textResource.URCapRequiresCB3();
            }
        }
        Log.warning((String)("Unsupported robot series :" + this.robotSeries));
        return "";
    }
}

