/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal;

import com.ur.polyscope.urcaps.ClassManager;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClassManagerImpl
extends SecurityManager
implements ClassManager {
    private Set<Class> filter = new HashSet<Class>();

    @Inject
    public ClassManagerImpl() {
    }

    public ClassManager addFilterClass(Class filterClass) {
        this.filter.add(filterClass);
        return this;
    }

    public Class getCallingClass(Class<?> thisClass) {
        Class[] classContext = this.getClassContextFromSecurityManager();
        int length = classContext.length;
        if (length < 2) {
            return classContext[0];
        }
        int idx = this.getIndexOfFirstFilteredClass(classContext);
        if (idx == length - 1) {
            return classContext[idx];
        }
        Class caller = classContext[idx + 1];
        int i = idx + 1;
        while (i < length) {
            Class aClass = classContext[i];
            if (!this.isAspectJMethod(thisClass, aClass) && !aClass.equals(thisClass)) {
                caller = aClass;
                break;
            }
            ++i;
        }
        return caller;
    }

    private boolean isAspectJMethod(Class<?> originalClass, Class<?> currentClass) {
        return this.isAspectJMethod(originalClass.getCanonicalName(), currentClass.getName());
    }

    protected boolean isAspectJMethod(String originalClassCanonicalName, String currentClassName) {
        boolean result = currentClassName.startsWith(originalClassCanonicalName) && currentClassName.contains("$AjcClosure");
        result |= currentClassName.startsWith("org.aspectj.");
        return result |= currentClassName.contains("aspects") && currentClassName.startsWith("com.ur.polyscope.");
    }

    private int getIndexOfFirstFilteredClass(Class[] classContext) {
        int i = this.skipSelf(classContext);
        int length = classContext.length;
        int j = i;
        while (j < length) {
            Class cls = classContext[j];
            if (this.filter.contains(cls)) {
                return j;
            }
            ++j;
        }
        return i - 1;
    }

    private int skipSelf(Class[] classContext) {
        int length = classContext.length;
        int i = 0;
        while (i < length) {
            Class cls = classContext[i];
            if (!cls.equals(this.getClass())) break;
            ++i;
        }
        return i;
    }

    Class[] getClassContextFromSecurityManager() {
        return this.getClassContext();
    }
}

