/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal;

import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.ExceptionHandling;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import java.util.ArrayList;
import java.util.Arrays;

public class ExceptionHandlingImpl
implements ExceptionHandling {
    private static final String[] VISIBLE_STACK_TRACE_ELEMENTS = new String[]{"com.ur.urcap.api.", "com.ur.urcap.conveyortracking.", "com.ur.urcap.ethernetip.", "com.ur.urcap.profinet.", "com.ur.urcap.examples.", "com.ur.urcap.sandbox.", "com.ur.urcap.testers-choice.", "com.ur.urcap.testerschoice."};
    private static final String[] HIDDEN_STACK_TRACE_ELEMENTS = new String[]{"com.ur.", "gui.program.", "gui.commandpanels", "org.aspectj.", "sun.reflect.", "java.lang.reflect.", "java.awt.", "java.security."};

    private static StackTraceElement[] createSubStackTrace(StackTraceElement[] elements, StackTraceElement javaFrameworkExitpoint) {
        int newLength = elements.length;
        int i = 0;
        while (i < elements.length) {
            if (ExceptionHandlingImpl.isExitPoint(elements[i], javaFrameworkExitpoint)) {
                newLength = i + 1;
            }
            ++i;
        }
        if (elements.length > newLength) {
            elements = Arrays.copyOf(elements, newLength);
        }
        return elements;
    }

    private static boolean isExitPoint(StackTraceElement element, StackTraceElement exitPoint) {
        if (exitPoint == null) {
            return false;
        }
        return element.getClassName().equals(exitPoint.getClassName()) && element.getFileName().equals(exitPoint.getFileName()) && element.getMethodName().equals(exitPoint.getMethodName());
    }

    private static StackTraceElement[] removeURElementsFromStackTrace(StackTraceElement[] elements) {
        ArrayList<StackTraceElement> filteredElements = new ArrayList<StackTraceElement>();
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (ExceptionHandlingImpl.isVisibleStackTraceElement(element)) {
                filteredElements.add(element);
            } else if (!ExceptionHandlingImpl.isHiddenStackTraceElement(element)) {
                filteredElements.add(element);
            }
            ++n2;
        }
        return filteredElements.toArray(new StackTraceElement[filteredElements.size()]);
    }

    private static boolean isVisibleStackTraceElement(StackTraceElement element) {
        return StringUtils.startsWithAnyIgnoreCase((String)element.getClassName(), (String[])VISIBLE_STACK_TRACE_ELEMENTS);
    }

    private static boolean isHiddenStackTraceElement(StackTraceElement element) {
        return StringUtils.startsWithAnyIgnoreCase((String)element.getClassName(), (String[])HIDDEN_STACK_TRACE_ELEMENTS);
    }

    private static String stackTraceToString(String errorMessage, StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        sb.append("<br/>");
        int i = 0;
        while (i < Math.min(10, elements.length)) {
            String[] split = elements[i].getClassName().split("\\.");
            String className = split[split.length - 1];
            sb.append(String.format("&nbsp;&nbsp;@%s.%s():%s<br/>", className, elements[i].getMethodName(), elements[i].getLineNumber()));
            ++i;
        }
        return sb.toString();
    }

    public String getStackTraceOutsidePolyScope(Throwable e) {
        if (e instanceof ProxiedException) {
            return this.getStackTraceOutsidePolyScope(e, ((ProxiedException)e).findCatchingMethod());
        }
        return this.getStackTraceOutsidePolyScope(e, Thread.currentThread().getStackTrace()[3]);
    }

    public String getStackTraceOutsidePolyScope(Throwable e, StackTraceElement javaFrameworkExitPoint) {
        StackTraceElement[] stackTraceElements = ExceptionHandlingImpl.createSubStackTrace(e.getStackTrace(), javaFrameworkExitPoint);
        StackTraceElement[] filteredElements = ExceptionHandlingImpl.removeURElementsFromStackTrace(stackTraceElements);
        return ExceptionHandlingImpl.stackTraceToString(e.toString(), filteredElements);
    }
}

