/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal;

import com.ur.polyscope.urcaps.ExceptionHandling;
import com.ur.polyscope.urcaps.URCapErrorHandler;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import javax.inject.Inject;

public class URCapErrorHandlerImpl
implements URCapErrorHandler {
    private final URCapErrorPanel errorPanel;
    private final ExceptionHandling exceptionHandling;
    protected String stackTrace;

    @Inject
    public URCapErrorHandlerImpl(URCapErrorPanel errorPanel, ExceptionHandling exceptionHandling) {
        this.errorPanel = errorPanel;
        this.exceptionHandling = exceptionHandling;
    }

    public URCapErrorPanel getErrorPanel() {
        this.errorPanel.setStackTrace(this.stackTrace);
        return this.errorPanel;
    }

    public void handle(Throwable e) {
        this.stackTrace = this.exceptionHandling.getStackTraceOutsidePolyScope(e);
    }

    public boolean hasError() {
        return this.stackTrace != null;
    }

    public void clearError() {
        this.stackTrace = null;
    }
}

