/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.polyscope.urcaps.internal.resources.ImageResource;
import com.ur.util.swing.HTML;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.osgi.framework.Bundle;

public class URCapErrorPanelImpl
extends URCapErrorPanel {
    private final JEditorPane metaInfo;
    private final JEditorPane stackTrace;
    private final JScrollPane stackTraceScrollPane;
    private final BundleUtils bundleUtils;
    private final FrameworkAdapter frameworkAdapter;

    @Inject
    public URCapErrorPanelImpl(TextResource textResource, BundleUtils bundleUtils, FrameworkAdapter frameworkAdapter) {
        this.frameworkAdapter = frameworkAdapter;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 2, 5, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.bundleUtils = bundleUtils;
        JLabel header = new JLabel(HTML.html((String)textResource.urcapErrorheader()), ImageResource.warningBigger(), 2);
        header.setBorder(new EmptyBorder(10, 10, 0, 0));
        JLabel contact = new JLabel(HTML.html((String)textResource.urcapErrorcontact()));
        contact.setBorder(new EmptyBorder(10, 10, 0, 0));
        this.metaInfo = new JEditorPane("text/html", "");
        this.metaInfo.setEditable(false);
        JScrollPane metaInfoScrollPane = new JScrollPane(this.metaInfo);
        metaInfoScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 10, 10, 10), new LineBorder(Color.black, 1)));
        this.stackTrace = new JEditorPane("text/html", "");
        this.stackTrace.setEditable(false);
        this.stackTraceScrollPane = new JScrollPane(this.stackTrace);
        this.stackTraceScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 10, 10, 10), new LineBorder(Color.black, 1)));
        this.stackTraceScrollPane.setVisible(false);
        c.gridx = 0;
        c.gridy = 0;
        this.add(header, c);
        c.gridy = 1;
        this.add(contact, c);
        c.gridy = 2;
        c.weighty = 0.3;
        this.add(metaInfoScrollPane, c);
        c.gridy = 3;
        c.weighty = 1.0;
        this.add(this.stackTraceScrollPane, c);
    }

    public void setMetadataFromClass(Class clazz) {
        Bundle bundle;
        if (clazz != null && (bundle = this.frameworkAdapter.getBundle(clazz)) != null) {
            this.metaInfo.setText(this.bundleUtils.buildMetaInfo(bundle, EnumSet.of(BundleUtils.BundleMetaField.NAME, BundleUtils.BundleMetaField.VERSION, BundleUtils.BundleMetaField.DEVELOPER, BundleUtils.BundleMetaField.CONTACT_INFO)));
        }
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace.setText(stackTrace);
        this.stackTraceScrollPane.setVisible(true);
    }
}

