/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal;

import com.ur.polyscope.urcaps.LoggerCallback;
import com.ur.polyscope.urcaps.SourceLoggable;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.URCapStartFilter;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityError;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import org.osgi.framework.Bundle;

public class URCapInternalPackageNameFilter
implements URCapStartFilter,
SourceLoggable<CompatibilityError> {
    private final TextResource textResource;
    private LoggerCallback<CompatibilityError> callback;

    @Inject
    public URCapInternalPackageNameFilter(TextResource textResource) {
        this.textResource = textResource;
    }

    public boolean allowStart(Bundle bundle) {
        String[] packages;
        String bundleSymbolicName = bundle.getSymbolicName();
        String[] stringArray = packages = ((String)bundle.getHeaders().get("Import-Package")).split(",");
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if ((p = p.trim()).startsWith("gui")) {
                this.logError(bundle);
                return false;
            }
            if (this.isUsingInternalRootPackage(p) || this.isUsingNonApiInternalPackageNotOwnedByBundle(bundleSymbolicName, p)) {
                this.logError(bundle);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isUsingInternalRootPackage(String p) {
        return p.startsWith("com.ur;") || p.equals("com.ur");
    }

    private boolean isUsingNonApiInternalPackageNotOwnedByBundle(String bundleSymbolicName, String p) {
        return p.startsWith("com.ur.") && !p.startsWith("com.ur.urcap.api") && !p.startsWith("com.ur.urweb.api") && !p.startsWith(bundleSymbolicName);
    }

    private void logError(Bundle bundle) {
        if (this.callback != null) {
            URCapInternalPackageNameError internalPackageError = new URCapInternalPackageNameError();
            this.callback.log((Object)internalPackageError);
        } else {
            Log.error((String)String.format("URCap %s is using internal PolyScope packages, which is not allowed.", bundle.getHeaders().get("Bundle-Name")));
        }
    }

    public void setLoggingCallback(LoggerCallback<CompatibilityError> callback) {
        this.callback = callback;
    }

    private class URCapInternalPackageNameError
    implements CompatibilityError {
        private URCapInternalPackageNameError() {
        }

        public String getMessage() {
            return "URCap is using internal PolyScope packages, which is not allowed.";
        }

        public String getLocalizedMessage() {
            return URCapInternalPackageNameFilter.this.textResource.URCapUsingInternalPackages();
        }

        public String getLocalizedTitle() {
            return "";
        }

        public String getLocalizedSuggestion() {
            return "";
        }
    }
}

