/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.aspects;

import com.google.inject.Inject;
import com.ur.exception.CustomUncaughtExceptionHandler;
import com.ur.lang.ClassUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.IgnoredChanges;
import com.ur.polyscope.program.undoredo.UndoRedoManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class IgnoreProgramChangesAspect
extends SecurityManager {
    private static UndoRedoManager undoRedoManager;
    private static CustomUncaughtExceptionHandler exceptionHandler;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ IgnoreProgramChangesAspect ajc$perSingletonInstance;

    @javax.inject.Inject
    public static void setUndoRedoManager(UndoRedoManager undoRedoManager) {
        IgnoreProgramChangesAspect.undoRedoManager = undoRedoManager;
    }

    @Inject(optional=true)
    public static synchronized void setCustomExceptionHandler(CustomUncaughtExceptionHandler customExceptionHandler) {
        exceptionHandler = customExceptionHandler;
    }

    @Around(value="execution(@(com.ur.polyscope.program.undoredo.IgnoreProgramChanges) * *.*(..))")
    public Object aroundAnnotatedMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.shouldProceedWithIgnore(joinPoint)) {
            return this.proceedWithIgnoring(joinPoint);
        }
        return joinPoint.proceed();
    }

    private boolean shouldProceedWithIgnore(ProceedingJoinPoint joinPoint) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return !IgnoreProgramChangesAspect.isUiOrEventThread() || !this.isNonUIThreadOnly(joinPoint);
    }

    private Object proceedWithIgnoring(final ProceedingJoinPoint joinPoint) throws Throwable {
        final Throwable[] exception = new Throwable[1];
        Object returnObject = undoRedoManager.ignoreChanges(new IgnoredChanges(){

            public Object executeChanges() {
                Object object = null;
                try {
                    object = IgnoreProgramChangesAspect.this.joinPointProceed(joinPoint);
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
                return object;
            }
        });
        if (exception[0] != null) {
            if (exceptionHandler != null) {
                exceptionHandler.setStackTraceClassesForThrowable((Class[])this.getClassContext(), exception[0]);
            }
            throw exception[0];
        }
        return returnObject;
    }

    Object joinPointProceed(ProceedingJoinPoint joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    boolean isNonUIThreadOnly(ProceedingJoinPoint joinPoint) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method nonUiThreadOnly;
        Annotation annotation = ClassUtils.getAnnotation((Object)this.getMethod(joinPoint), IgnoreProgramChanges.class);
        if (annotation != null && (nonUiThreadOnly = annotation.annotationType().getDeclaredMethod("NonUIThreadOnly", new Class[0])) != null) {
            return (Boolean)nonUiThreadOnly.invoke((Object)annotation, new Object[0]);
        }
        return false;
    }

    private Method getMethod(ProceedingJoinPoint proceedingJoinPoint) {
        return ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
    }

    private static boolean isUiOrEventThread() {
        return SwingUtilities.isEventDispatchThread() || StringUtils.equalsAny((String)Thread.currentThread().getName(), (String[])new String[]{"AWT-EventQueue-0", "AWT-EventQueue-1", "AWT-EventQueue-2", "Thread-0"});
    }

    public static IgnoreProgramChangesAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.ur.polyscope.urcaps.internal.aspects.IgnoreProgramChangesAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            IgnoreProgramChangesAspect.ajc$perSingletonInstance = new IgnoreProgramChangesAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

