/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.internal.daemonservice.Daemon;
import com.ur.util.URLUtils;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;

public abstract class AbstractDaemonAdminService {
    private static final String USER = System.getenv("USER") == null ? "dummy" : System.getenv("USER");
    protected static String BUNDLE_START_TAG = "bundle";
    protected static String SYMBOLIC_LINK_DELIMITER = "@";

    protected static boolean isOnURSimVM() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (IOException e) {
            Log.error((String)"Error reading hostname from localhost", (Throwable)e);
        }
        return "ursim".equals(hostname);
    }

    protected boolean isOnMac() {
        return System.getProperty("os.name").contains("Mac");
    }

    protected void ensureDirectoryExists(File directory) throws IOException {
        directory.mkdirs();
        if (!directory.isDirectory()) {
            throw new IOException("Could not create directory " + directory.getAbsolutePath());
        }
    }

    public boolean isOnRobot() {
        return "kiosk".equals(USER) || "root".equals(USER);
    }

    protected File getExecutablePath(Daemon daemon) throws IOException {
        String workingDir = daemon.getWorkingDir();
        URL url = daemon.getDaemonService().getExecutable();
        File executable = new File(workingDir, URLUtils.getPath((URL)url));
        return executable.getCanonicalFile();
    }

    protected String getExecutableHashCode(Daemon daemon) {
        return String.valueOf(daemon.getExecutable().hashCode());
    }

    protected void createSymLink(String executablePath, String symLinkPath) throws IOException {
        String command = "ln -sf " + executablePath + " " + symLinkPath;
        BashScriptRunner runner = new BashScriptRunner(command);
        runner.execute();
        if (runner.getReturnVal() != 0 || !new File(symLinkPath).exists()) {
            throw new IOException("Could not create service symlink " + symLinkPath + " to " + executablePath);
        }
    }

    public void unregisterBrokenSymLinkDaemons() {
        String serviceDirectory;
        try {
            serviceDirectory = this.getServiceDirectory().getCanonicalPath();
        }
        catch (IOException e) {
            Log.error((String)"Fatal error: Could not get service directory", (Throwable)e);
            return;
        }
        String command = "find " + serviceDirectory + " -xtype l | grep " + BUNDLE_START_TAG;
        BashScriptRunner bashScriptRunner = new BashScriptRunner(command);
        try {
            bashScriptRunner.execute();
        }
        catch (IOException e) {
            Log.error((String)"Failed to get list of possibly broken daemon symlinks", (Throwable)e);
            return;
        }
        String outputString = bashScriptRunner.getOutputString();
        if (!StringUtils.isNullOrOnlyWhitespace((String)outputString)) {
            String[] deadServiceDaemonSymlinks;
            String[] stringArray = deadServiceDaemonSymlinks = outputString.split("\n");
            int n = deadServiceDaemonSymlinks.length;
            int n2 = 0;
            while (n2 < n) {
                String symlinkName = stringArray[n2];
                File symlinkFile = new File(symlinkName);
                try {
                    new BashScriptRunner("pkill -f " + symlinkFile.getName()).execute();
                }
                catch (IOException e) {
                    Log.error((String)"Failed to stop service daemon", (Throwable)e);
                }
                symlinkFile.delete();
                ++n2;
            }
        }
    }

    protected abstract File getServiceDirectory() throws IOException;
}

