/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.ur.polyscope.urcaps.internal.daemonservice.BundleResolver;
import com.ur.polyscope.urcaps.internal.daemonservice.Registration;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.Bundle;

public class DaemonExtractionRegistration {
    private final File dataFile;
    private final List<Registration> registrations;
    private final BundleResolver resolver;

    public DaemonExtractionRegistration(File dataFile, BundleResolver resolver) {
        this.dataFile = dataFile;
        this.resolver = resolver;
        this.registrations = dataFile.exists() ? this.readFile() : new ArrayList<Registration>();
        this.cleanUp();
    }

    private void cleanUp() {
        Iterator<Registration> iterator = this.registrations.iterator();
        while (iterator.hasNext()) {
            Registration registration = iterator.next();
            if (this.resolver.exists(registration)) continue;
            iterator.remove();
        }
        this.saveFile();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Registration> readFile() {
        Gson gson = new Gson();
        FileReader reader = null;
        List result = null;
        try {
            reader = new FileReader(this.dataFile);
            result = (List)gson.fromJson((Reader)reader, new TypeToken<List<Registration>>(){}.getType());
        }
        catch (FileNotFoundException e) {
            Log.error((String)"Daemon registration file not found", (Throwable)e);
            if (reader == null) return result != null ? result : new ArrayList();
            try {
                reader.close();
                return result != null ? result : new ArrayList();
            }
            catch (IOException e2) {
                Log.error((String)"Could not close daemon registration file", (Throwable)e2);
            }
            return result != null ? result : new ArrayList();
        }
        catch (JsonIOException e) {
            Log.error((String)"Json IO error in Daemon registration file", (Throwable)e);
            return result != null ? result : new ArrayList();
        }
        catch (JsonSyntaxException e) {
            Log.error((String)"Json syntax error in Daemon registration file", (Throwable)e);
            if (reader == null) return result != null ? result : new ArrayList();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            try {
                reader.close();
                return result != null ? result : new ArrayList();
            }
            catch (IOException e3) {
                Log.error((String)"Could not close daemon registration file", (Throwable)e3);
            }
            return result != null ? result : new ArrayList();
        }
        {
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.error((String)"Could not close daemon registration file", (Throwable)e);
                    }
                }
            }
        }
        if (reader == null) return result != null ? result : new ArrayList();
        try {
            reader.close();
            return result != null ? result : new ArrayList();
        }
        catch (IOException e) {
            Log.error((String)"Could not close daemon registration file", (Throwable)e);
        }
        return result != null ? result : new ArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(this.dataFile);
                gson.toJson(this.registrations, (Appendable)fileWriter);
                fileWriter.flush();
                return;
            }
            catch (IOException e) {
                Log.error((String)"Could not save daemon registration file", (Throwable)e);
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (IOException e2) {
                    Log.error((String)"Could not close daemon registration file", (Throwable)e2);
                }
                return;
            }
            catch (JsonIOException e) {
                Log.error((String)"IO exception when saving daemon registration file", (Throwable)e);
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (IOException e3) {
                    Log.error((String)"Could not close daemon registration file", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    Log.error((String)"Could not close daemon registration file", (Throwable)e);
                }
            }
        }
    }

    public boolean shouldExtract(Bundle bundle, URL url) {
        Registration newRegistration = new Registration(bundle, url);
        for (Registration registration : this.registrations) {
            if (!registration.equals(newRegistration)) continue;
            return false;
        }
        return true;
    }

    public void registerExtraction(Bundle bundle, URL url) {
        Registration registration = new Registration(bundle, url);
        this.registrations.add(registration);
        this.saveFile();
    }
}

