/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.daemonservice.DaemonStateListener;
import com.ur.polyscope.urcaps.internal.daemonservice.Daemon;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonExtractionRegistration;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl$AjcClosure1;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl$AjcClosure3;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl$AjcClosure5;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl$AjcClosure7;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonRunService;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.DaemonService;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.osgi.framework.Bundle;

public class DaemonImpl
implements DaemonContribution,
Daemon {
    private final long STATE_UPDATE_INTERVAL_MS = 250L;
    private final Bundle bundle;
    private final DaemonService daemonService;
    private final DaemonRunService daemonRunService;
    private final DaemonExtractionRegistration extractionRegistration;
    private final StateProxy stateProxy;
    private DaemonContribution.State desiredState = DaemonContribution.State.STOPPED;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public DaemonImpl(Bundle bundle, DaemonService daemonService, DaemonRunService daemonRunService, DaemonExtractionRegistration extractionRegistration) {
        this.bundle = bundle;
        this.daemonService = daemonService;
        this.daemonRunService = daemonRunService;
        this.extractionRegistration = extractionRegistration;
        this.stateProxy = new StateProxy();
    }

    public void installResource(URL url) {
        URL uRL = url;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)uRL);
        Object[] objectArray = new Object[]{this, uRL, joinPoint};
        DaemonImpl$AjcClosure1 daemonImpl$AjcClosure1 = new DaemonImpl$AjcClosure1(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(daemonImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void extractDaemonResources(URL url) {
        try {
            BundleUtils.extractFromBundle((Bundle)this.bundle, (URL)url);
        }
        catch (Exception ex) {
            Log.error((String)("Failed to extract daemon resources from URCap bundle: " + ex));
        }
    }

    @Override
    public URL getExecutable() {
        return this.daemonService.getExecutable();
    }

    @Override
    public String getBundleSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public DaemonService getDaemonService() {
        return this.daemonService;
    }

    @Override
    public String getWorkingDir() throws IOException {
        return this.getDataFileRoot().getCanonicalPath();
    }

    private File getDataFileRoot() {
        return this.bundle.getDataFile("");
    }

    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DaemonImpl$AjcClosure3 daemonImpl$AjcClosure3 = new DaemonImpl$AjcClosure3(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(daemonImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private void fireDaemonStateChanged(final DaemonContribution.State stateToWaitFor) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean stateReached = Waiting.until((Waiting.ItHappens)new NewStateReached(stateToWaitFor), (int)10, (TimeUnit)TimeUnit.SECONDS);
                if (stateReached) {
                    EventNotificationService.notify(DaemonStateListener.class, (NotificationStrategy)new SendStateChangeNotification(stateToWaitFor));
                }
            }
        }).start();
    }

    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DaemonImpl$AjcClosure5 daemonImpl$AjcClosure5 = new DaemonImpl$AjcClosure5(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(daemonImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public DaemonContribution.State getState() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DaemonImpl$AjcClosure7 daemonImpl$AjcClosure7 = new DaemonImpl$AjcClosure7(objectArray);
        return (DaemonContribution.State)UncaughtExceptionAspect.aspectOf().aroundMethod(daemonImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    static {
        DaemonImpl.ajc$preClinit();
    }

    static final /* synthetic */ void installResource_aroundBody0(DaemonImpl ajc$this, URL url, JoinPoint joinPoint) {
        if (ajc$this.extractionRegistration.shouldExtract(ajc$this.bundle, url)) {
            ajc$this.extractDaemonResources(url);
            ajc$this.extractionRegistration.registerExtraction(ajc$this.bundle, url);
        }
    }

    static final /* synthetic */ void start_aroundBody2(DaemonImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.daemonRunService.start(ajc$this);
        ajc$this.desiredState = DaemonContribution.State.RUNNING;
        ajc$this.stateProxy.reset();
        ajc$this.fireDaemonStateChanged(DaemonContribution.State.RUNNING);
    }

    static final /* synthetic */ void stop_aroundBody4(DaemonImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.daemonRunService.stop(ajc$this);
        ajc$this.desiredState = DaemonContribution.State.STOPPED;
        ajc$this.stateProxy.reset();
        ajc$this.fireDaemonStateChanged(DaemonContribution.State.STOPPED);
    }

    static final /* synthetic */ DaemonContribution.State getState_aroundBody6(DaemonImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.stateProxy.getState();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DaemonImpl.java", DaemonImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "installResource", "com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl", "java.net.URL", "url", "", "void"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl", "", "", "", "void"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl", "", "", "", "void"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getState", "com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl", "", "", "", "com.ur.urcap.api.contribution.DaemonContribution$State"), 111);
    }

    private class NewStateReached
    implements Waiting.ItHappens {
        private final DaemonContribution.State stateToWaitFor;

        public NewStateReached(DaemonContribution.State stateToWaitFor) {
            this.stateToWaitFor = stateToWaitFor;
        }

        public boolean itHappened() {
            return DaemonImpl.this.getState() == this.stateToWaitFor;
        }
    }

    private static class SendStateChangeNotification
    implements NotificationStrategy<DaemonStateListener> {
        private final DaemonContribution.State stateToWaitFor;

        public SendStateChangeNotification(DaemonContribution.State stateToWaitFor) {
            this.stateToWaitFor = stateToWaitFor;
        }

        public void notify(DaemonStateListener daemonStateListener) {
            daemonStateListener.stateChanged(this.stateToWaitFor);
        }
    }

    private class StateProxy {
        private DaemonContribution.State state;
        private long lastStateUpdateTime = 0L;

        private StateProxy() {
        }

        private DaemonContribution.State getState() {
            long currentTime = System.currentTimeMillis();
            if (this.mustUpdateDaemonState(currentTime)) {
                this.updateDaemonState();
            }
            return this.state;
        }

        private void updateDaemonState() {
            this.state = this.createState();
            this.lastStateUpdateTime = System.currentTimeMillis();
        }

        private boolean mustUpdateDaemonState(long currentTime) {
            return this.lastStateUpdateTime + 250L < currentTime;
        }

        private DaemonContribution.State createState() {
            boolean running = DaemonImpl.this.daemonRunService.isRunning(DaemonImpl.this);
            if (DaemonImpl.this.desiredState == DaemonContribution.State.RUNNING && !running) {
                return DaemonContribution.State.ERROR;
            }
            return running ? DaemonContribution.State.RUNNING : DaemonContribution.State.STOPPED;
        }

        private void reset() {
            this.lastStateUpdateTime = 0L;
        }
    }
}

